/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.tasklist.filters.InlineTasksReadOnlyAccessFilterDynamicBinding;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.InlineTaskSearchIndexAccessor;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.indexqueue.IndexQueueProcessor;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.indexqueue.IndexTaskRegistrator;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search-index")
@InlineTasksReadOnlyAccessFilterDynamicBinding
@Consumes(value={"application/json"})
public class TaskSearchIndexResource {
    private static final Logger log = LoggerFactory.getLogger(TaskSearchIndexResource.class);
    private final PermissionManager permissionManager;
    private final IndexQueueProcessor indexQueueProcessor;
    private final IndexTaskRegistrator indexTaskRegistrator;
    private final InlineTaskSearchIndexAccessor searchIndexAccessor;

    @Inject
    public TaskSearchIndexResource(PermissionManager permissionManager, IndexQueueProcessor indexQueueProcessor, IndexTaskRegistrator indexTaskRegistrator, InlineTaskSearchIndexAccessor searchIndexAccessor) {
        this.permissionManager = permissionManager;
        this.indexQueueProcessor = indexQueueProcessor;
        this.indexTaskRegistrator = indexTaskRegistrator;
        this.searchIndexAccessor = searchIndexAccessor;
    }

    @POST
    @Path(value="/flush")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response flushIndex() {
        if (!this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.indexQueueProcessor.flushQueue();
        try {
            this.searchIndexAccessor.refreshIndex();
        }
        catch (IOException e) {
            log.error("Error refreshing inline task index", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/reindex-all")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml", "application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response reIndexAll() {
        if (!this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.indexTaskRegistrator.requestToReindexAllInlineTasks();
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

