/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.service;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XMLEventFactoryProvider;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactory;
import com.atlassian.confluence.content.render.xhtml.storage.inlinetask.StorageInlineTaskConstants;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.OperationTrigger;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.atlassian.confluence.plugins.tasklist.ao.dao.InlineTaskDao;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.TasksFinderViaSearchIndex;
import com.atlassian.confluence.plugins.tasklist.report.searchindex.indexmanagement.TaskReportIndexPersistedStateService;
import com.atlassian.confluence.plugins.tasklist.search.SearchTaskParameters;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskResponse;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.plugins.tasklist.service.TaskPaginationService;
import com.atlassian.confluence.plugins.tasklist.transformer.TaskVisitor;
import com.atlassian.confluence.plugins.tasklist.transformer.helper.XMLSink;
import com.atlassian.confluence.plugins.tasklist.transformer.xml.ParsingContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.diffs.MergeResult;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringReader;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultInlineTaskService
implements InlineTaskService {
    private static final Logger log = LoggerFactory.getLogger(DefaultInlineTaskService.class);
    private static final int MAX_LIMIT_FOR_REQUEST = 5000;
    private final PageManager pageManager;
    private final DraftManager draftManager;
    private final XmlEventReaderFactory readerFactory;
    private final XMLEventFactory xmlEventFactory;
    private final XmlOutputFactory writerFactory;
    private final PermissionManager permissionManager;
    private final ClusterLockService lockFactory;
    private final InlineTaskDao inlineTaskDao;
    private final PaginationService paginationService;
    private final UserAccessor userAccessor;
    private final DarkFeatureManager darkFeatureManager;
    private final HttpContext httpContext;
    private final TasksFinderViaSearchIndex tasksFinderViaSearchIndex;
    private final TransactionTemplate transactionTemplate;
    private final TaskReportIndexPersistedStateService taskReportIndexPersistedStateService;
    private static final String USE_DATABASE_FOR_TASK_REPORT_MACRO_DARK_FEATURE_NAME = "confluence.task-report.use-database-for-reports";

    @Autowired
    public DefaultInlineTaskService(PageManager pageManager, DraftManager draftManager, @ConfluenceImport ClusterLockService lockFactory, XmlEventReaderFactory inFactory, XMLEventFactoryProvider xmlEventFactory, @Qualifier(value="xmlOutputFactory") XmlOutputFactory outFactory, PermissionManager pm, InlineTaskDao inlineTaskDao, PaginationService paginationService, UserAccessor userAccessor, DarkFeatureManager darkFeatureManager, HttpContext httpContext, TasksFinderViaSearchIndex tasksFinderViaSearchIndex, TaskReportIndexPersistedStateService taskReportIndexPersistedStateService, TransactionTemplate transactionTemplate) {
        this.pageManager = pageManager;
        this.draftManager = draftManager;
        this.readerFactory = inFactory;
        this.inlineTaskDao = inlineTaskDao;
        this.paginationService = paginationService;
        this.userAccessor = userAccessor;
        this.darkFeatureManager = darkFeatureManager;
        this.xmlEventFactory = xmlEventFactory.getXmlEventFactory();
        this.writerFactory = outFactory;
        this.permissionManager = pm;
        this.lockFactory = lockFactory;
        this.httpContext = httpContext;
        this.tasksFinderViaSearchIndex = tasksFinderViaSearchIndex;
        this.taskReportIndexPersistedStateService = taskReportIndexPersistedStateService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Deprecated
    public InlineTaskResponse setTaskStatus(ContentEntityObject cob, String taskId, TaskStatus newStatus, PageUpdateTrigger trigger) {
        if (cob == null) {
            throw new IllegalArgumentException("Invalid contentId, or not sufficient permissions");
        }
        return this.setBatchedTaskStatus(cob.getId(), Map.of(taskId, newStatus), trigger);
    }

    @Override
    public InlineTaskResponse setBatchedTaskStatus(long cid, Map<String, TaskStatus> taskIdToStatusMap, PageUpdateTrigger trigger) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Long startTime = null;
        ClusterLock lock = this.lockFactory.getLockForName("InlineTaskService.updatePage." + cid);
        lock.lock();
        try {
            InlineTaskResponse inlineTaskResponse;
            block10: {
                Ticker ignored = Timers.start((String)"DefaultInlineTaskService.setBatchedTaskStatus()");
                try {
                    startTime = System.currentTimeMillis();
                    inlineTaskResponse = (InlineTaskResponse)((Object)this.transactionTemplate.execute(() -> this.setBatchedTaskStatusImpl(cid, taskIdToStatusMap, trigger, user)));
                    if (ignored == null) break block10;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return inlineTaskResponse;
        }
        finally {
            lock.unlock();
            if (startTime != null) {
                long timeElapsed = System.currentTimeMillis() - startTime;
                log.debug("InlineTasks: updated {} tasks in {} ms", (Object)1, (Object)timeElapsed);
            }
        }
    }

    private InlineTaskResponse setBatchedTaskStatusImpl(long cid, Map<String, TaskStatus> taskIdToStatusMap, PageUpdateTrigger trigger, ConfluenceUser user) {
        ContentEntityObject cob = this.pageManager.getById(cid);
        AtomicBoolean found = new AtomicBoolean(false);
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, (Object)cob)) {
            return InlineTaskResponse.NOT_PERMITTED;
        }
        if (cob == null) {
            throw new IllegalArgumentException("Invalid contentId, or not sufficient permissions");
        }
        StringReader reader = new StringReader(cob.getBodyAsString());
        DefaultConversionContext ctx = new DefaultConversionContext((RenderContext)new PageContext(cob));
        try {
            VisitTaskImpl visitTask = new VisitTaskImpl(taskIdToStatusMap, found);
            String xmlBody = TaskVisitor.transformTask(this.readerFactory, this.writerFactory, this.xmlEventFactory, reader, (ConversionContext)ctx, 0L, visitTask);
            if (found.get()) {
                return this.updatePage(cob, xmlBody, visitTask.verifyAllTasksUpdated(), trigger);
            }
        }
        catch (XhtmlException e) {
            log.error(e.toString(), (Throwable)e);
            throw new RuntimeException("Internal error", e);
        }
        catch (CloneNotSupportedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        return InlineTaskResponse.TASK_NOT_FOUND;
    }

    @Override
    public Task find(long globalId) {
        return this.inlineTaskDao.find(globalId);
    }

    @Override
    public Task find(long contentId, long id) {
        return this.inlineTaskDao.find(contentId, id);
    }

    @Override
    public Set<Long> findTaskIdsByContentId(long contentId) {
        return this.inlineTaskDao.findTaskIdsByContentId(contentId);
    }

    @Override
    public Task create(Task task) {
        return this.inlineTaskDao.create(task);
    }

    @Override
    public Task update(Task task, String performerName, boolean hasStatusChanged, boolean hasBodyChanged) {
        Task updatedTask = this.updateTask(task);
        if (updatedTask == null) {
            return null;
        }
        if (hasStatusChanged) {
            updatedTask = task.getStatus() == TaskStatus.CHECKED ? new Task.Builder(updatedTask).withCompleteUser(performerName).withCompleteDate(new Date()).build() : new Task.Builder(updatedTask).withCompleteUser(null).withCompleteDate(null).withUpdateDate(new Date()).build();
        }
        if (hasBodyChanged) {
            updatedTask = new Task.Builder(updatedTask).withUpdateDate(new Date()).build();
        }
        return this.inlineTaskDao.update(updatedTask);
    }

    @Override
    public void delete(long globalId) {
        this.inlineTaskDao.delete(globalId);
    }

    @Override
    public void delete(long contentId, long id) {
        this.inlineTaskDao.delete(contentId, id);
    }

    private Task updateTask(Task task) {
        Task persistedTask = this.inlineTaskDao.find(task.getContentId(), task.getId());
        if (persistedTask != null) {
            return new Task.Builder(persistedTask).withContentId(task.getContentId()).withStatus(task.getStatus()).withTitle(task.getTitle()).withBody(task.getBody()).withAssignee(task.getAssignee()).withDueDate(task.getDueDate()).build();
        }
        return null;
    }

    @Override
    public void delete(Task task) {
        this.inlineTaskDao.delete(task.getContentId(), task.getId());
    }

    @Override
    public void deleteBySpaceId(long spaceId) {
        this.inlineTaskDao.deleteBySpaceId(spaceId);
    }

    @Override
    public PageResponse<Task> searchTasks(SearchTaskParameters params) {
        if (this.shouldUseSearchMechanismForTaskReports()) {
            log.debug("Tasks will be retrieved from the search index.");
            return this.getTasksFromSearchIndex(params);
        }
        log.debug("Tasks will be retrieved from the database.");
        return this.searchTasksWithRegularPermissions(params);
    }

    private boolean shouldUseSearchMechanismForTaskReports() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        if (request != null && StringUtils.isNotEmpty((CharSequence)request.getParameter("use-database"))) {
            return false;
        }
        if (!this.taskReportIndexPersistedStateService.isIndexReady()) {
            log.debug("Search index cannot be used because search index is not ready.");
            return false;
        }
        return this.darkFeatureManager.isEnabledForAllUsers(USE_DATABASE_FOR_TASK_REPORT_MACRO_DARK_FEATURE_NAME).orElse(false) == false;
    }

    private PageResponse<Task> searchTasksWithRegularPermissions(SearchTaskParameters params) {
        int startPage = params.getPageIndex() * params.getPageSize();
        int endPage = startPage + params.getPageSize() * params.getDisplayedPages();
        SimplePageRequest pageRequest = new SimplePageRequest(startPage, endPage);
        PageResponse<Task> response = this.inlineTaskDao.searchTask(params, new TaskPaginationService(this.permissionManager, this.pageManager, this.paginationService, this.userAccessor), (PageRequest)pageRequest);
        int totalPages = 7;
        if (!response.hasMore()) {
            int additionalPages = (int)Math.ceil((double)response.size() / (double)params.getPageSize());
            totalPages = params.getPageIndex() + additionalPages;
        }
        params.setTotalPages(totalPages);
        return response;
    }

    private PageResponse<Task> getTasksFromSearchIndex(SearchTaskParameters params) {
        try {
            int startPage = params.getPageIndex() * params.getPageSize();
            int endPage = startPage + params.getPageSize() * params.getDisplayedPages();
            SimplePageRequest pageRequest = new SimplePageRequest(startPage, endPage);
            List<Task> tasks = this.tasksFinderViaSearchIndex.find(params, pageRequest.getStart(), pageRequest.getLimit() - pageRequest.getStart());
            PageResponse<Task> response = this.createPageResponse(tasks, (PageRequest)pageRequest);
            int totalPages = 7;
            if (!response.hasMore()) {
                int additionalPages = (int)Math.ceil((double)response.size() / (double)params.getPageSize());
                totalPages = params.getPageIndex() + additionalPages;
            }
            params.setTotalPages(totalPages);
            return response;
        }
        catch (InvalidSearchException e) {
            throw new IllegalStateException(e);
        }
    }

    private PageResponse<Task> createPageResponse(List<Task> tasks, PageRequest pageRequest) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)5000);
        if (tasks == null || tasks.isEmpty()) {
            return PageResponseImpl.from(Collections.emptyList(), (boolean)false).pageRequest(limitedRequest).build();
        }
        List<Task> subList = tasks.subList(0, Math.min(limitedRequest.getLimit() - limitedRequest.getStart(), tasks.size()));
        boolean hasMore = tasks.size() > limitedRequest.getLimit() - limitedRequest.getStart();
        return PageResponseImpl.from(subList, (boolean)hasMore).pageRequest(pageRequest).build();
    }

    @Override
    public long countAllTasks() {
        return this.inlineTaskDao.countAll();
    }

    private InlineTaskResponse updatePage(ContentEntityObject page, String newBody, boolean allUpdated, PageUpdateTrigger trigger) throws CloneNotSupportedException {
        Draft draft = new Draft();
        draft.setPageId(page.getIdAsString());
        draft.setPageVersion(page.getVersion());
        draft.setBodyAsString(newBody);
        while (true) {
            if (!this.draftManager.isMergeRequired(draft)) {
                ContentEntityObject originalPage = (ContentEntityObject)page.clone();
                page.setVersionComment(null);
                page.setBodyAsString(draft.getBodyAsString());
                this.pageManager.saveContentEntity(page, originalPage, (SaveContext)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(false)).updateLastModifier(true).suppressEvents(false)).updateTrigger((OperationTrigger)trigger)).build());
                return allUpdated ? InlineTaskResponse.SUCCESS : InlineTaskResponse.TASK_NOT_FOUND;
            }
            log.debug("Merge required while applying inline task change. Draft version {}, page version {}", (Object)draft.getPageVersion(), (Object)page.getVersion());
            this.pageManager.refreshContentEntity(page);
            MergeResult mergeResult = this.draftManager.mergeContent(draft);
            if (mergeResult.hasConflicts()) {
                return InlineTaskResponse.MERGE_CONFLICT;
            }
            draft.setPageVersion(page.getVersion());
            draft.setBodyAsString(mergeResult.getMergedContent());
        }
    }

    private ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    static class VisitTaskImpl
    implements TaskVisitor.VisitTask {
        private final Map<String, TaskStatus> tasks;
        private final AtomicBoolean found;
        private int numTasksMatched = 0;

        VisitTaskImpl(String taskId, TaskStatus newStatus, AtomicBoolean found) {
            this.tasks = Map.of(taskId, newStatus);
            this.found = found;
        }

        VisitTaskImpl(Map<String, TaskStatus> taskStatusRequests, AtomicBoolean found) {
            this.tasks = taskStatusRequests;
            this.found = found;
        }

        boolean verifyAllTasksUpdated() {
            return this.numTasksMatched == this.tasks.size();
        }

        @Override
        public boolean consumeTaskIfHandled(ParsingContext context, XMLEventReader xmlReader, XMLSink xmlWriter) throws XMLStreamException {
            while (xmlReader.hasNext()) {
                if (xmlReader.peek().isStartElement() && StorageInlineTaskConstants.TASK_ELEMENT.equals(xmlReader.peek().asStartElement().getName())) {
                    String foundTaskIdMatch = null;
                    xmlWriter.add(xmlReader.nextEvent());
                    while (xmlReader.hasNext()) {
                        XMLEvent nextEvent = xmlReader.peek();
                        if (nextEvent.isStartElement() && StorageInlineTaskConstants.TASK_ID_ELEMENT.equals(nextEvent.asStartElement().getName())) {
                            foundTaskIdMatch = this.handleIdAndCheckIfMatch(xmlReader, xmlWriter);
                            continue;
                        }
                        if (nextEvent.isStartElement() && StorageInlineTaskConstants.TASK_STATUS_ELEMENT.equals(nextEvent.asStartElement().getName())) {
                            this.handleStatus(context, xmlReader, xmlWriter, foundTaskIdMatch);
                            continue;
                        }
                        xmlWriter.add(xmlReader.nextEvent());
                    }
                    return true;
                }
                XMLEvent event = xmlReader.nextEvent();
                xmlWriter.add(event);
                if (!event.isEndElement() || !StorageInlineTaskConstants.TASK_ELEMENT.equals(event.asEndElement().getName())) continue;
                break;
            }
            return true;
        }

        private String handleIdAndCheckIfMatch(XMLEventReader xmlReader, XMLSink xmlWriter) throws XMLStreamException {
            String foundMatch = null;
            xmlWriter.add(xmlReader.nextEvent());
            XMLEvent taskIdEvent = xmlReader.nextEvent();
            String currentId = taskIdEvent.asCharacters().getData();
            if (taskIdEvent.isCharacters() && this.tasks.containsKey(currentId)) {
                foundMatch = currentId;
                this.found.set(true);
                ++this.numTasksMatched;
            }
            xmlWriter.add(taskIdEvent);
            xmlWriter.add(xmlReader.nextEvent());
            return foundMatch;
        }

        private void handleStatus(ParsingContext context, XMLEventReader xmlReader, XMLSink xmlWriter, String matchedId) throws XMLStreamException {
            String matchedStatusStr;
            String taskStatus;
            xmlWriter.add(xmlReader.nextEvent());
            XMLEvent taskStatusEvent = xmlReader.nextEvent();
            if (matchedId != null && !(taskStatus = taskStatusEvent.asCharacters().getData()).equals(matchedStatusStr = this.storageEquivalent(this.tasks.get(matchedId)))) {
                taskStatusEvent = context.getEventFactory().createCharacters(matchedStatusStr);
            }
            xmlWriter.add(taskStatusEvent);
            xmlWriter.add(xmlReader.nextEvent());
        }

        private String storageEquivalent(TaskStatus status) {
            if (status == TaskStatus.CHECKED) {
                return StorageInlineTaskConstants.TASK_STATUS_COMPLETE;
            }
            return StorageInlineTaskConstants.TASK_STATUS_INCOMPLETE;
        }
    }
}

