/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.serialization;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.InMemoryFormat;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.config.NearCacheConfig;
import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.IAtomicLong;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.MemberAttributeEvent;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.map.listener.EntryAddedListener;
import com.atlassian.nutcluster.map.listener.MapListener;
import com.atlassian.nutcluster.serialization.BundleKey;
import com.atlassian.nutcluster.serialization.OsgiBundleIdMergePolicy;
import com.atlassian.nutcluster.serialization.OsgiClassLoaderRegistry;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.osgi.container.OsgiContainerStartedEvent;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiClassLoaderRegistrySynchronizer {
    private static final Logger log = LoggerFactory.getLogger(OsgiClassLoaderRegistrySynchronizer.class);
    public static final String OSGI_BUNDLE_TO_ID_MAP = "atl.extras.osgi.bundle.map";
    public static final String OSGI_BUNDLE_ID_SEQUENCE = "atl.extras.osgi.bundle.id.sequence";
    private final IMap<BundleKey, Integer> clusterBundleToId;
    private final IMap<Integer, BundleKey> clusterIdToBundle;
    private final IAtomicLong clusterIdSequence;
    private final String entryListenerId;
    private final NutclusterInstance nutcluster;
    private final String membershipListenerId;
    private final OsgiClassLoaderRegistry registry;

    public OsgiClassLoaderRegistrySynchronizer(NutclusterInstance nutcluster, OsgiClassLoaderRegistry registry) {
        this.nutcluster = nutcluster;
        this.registry = registry;
        this.clusterIdSequence = nutcluster.getAtomicLong(OSGI_BUNDLE_ID_SEQUENCE);
        int randomOffset = new Random(System.nanoTime()).nextInt(214748) * 10000;
        this.clusterIdSequence.compareAndSet(0L, (long)randomOffset);
        this.clusterBundleToId = nutcluster.getMap(OSGI_BUNDLE_TO_ID_MAP);
        this.clusterIdToBundle = nutcluster.getMap(OSGI_BUNDLE_TO_ID_MAP);
        this.entryListenerId = this.clusterIdToBundle.addEntryListener((MapListener)new RegistryUpdatingEntryAddedListener(), true);
        this.membershipListenerId = nutcluster.getCluster().addMembershipListener((MembershipListener)new RegistryUpdatingMembershipListener());
    }

    @PreDestroy
    public void destroy() {
        this.clusterIdToBundle.removeEntryListener(this.entryListenerId);
        this.nutcluster.getCluster().removeMembershipListener(this.membershipListenerId);
    }

    @PluginEventListener
    public void onContainerStarted(OsgiContainerStartedEvent event) {
        Bundle[] bundles = event.getOsgiContainerManager().getBundles();
        if (bundles == null || bundles.length == 0) {
            return;
        }
        Bundle systemBundle = bundles[0].getBundleContext().getBundle(0L);
        systemBundle.getBundleContext().addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                Bundle bundle = event.getBundle();
                switch (event.getType()) {
                    case 4: 
                    case 16: {
                        OsgiClassLoaderRegistrySynchronizer.this.unregisterBundle(bundle);
                        log.debug("Unregistered bundle {}:{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
                        break;
                    }
                    case 2: {
                        OsgiClassLoaderRegistrySynchronizer.this.registerBundle(bundle);
                    }
                }
            }
        });
        for (Bundle b : bundles) {
            this.registerBundle(b);
        }
        this.synchronizeRegistry();
    }

    public static void configure(Config config) {
        config.addMapConfig(new MapConfig(OSGI_BUNDLE_TO_ID_MAP).setMergePolicy(OsgiBundleIdMergePolicy.class.getName()).setNearCacheConfig(new NearCacheConfig().setInMemoryFormat(InMemoryFormat.OBJECT).setInvalidateOnChange(true).setCacheLocalEntries(true)));
    }

    private void registerBundle(Bundle bundle) {
        BundleKey key = new BundleKey(bundle);
        Integer id = (Integer)this.clusterBundleToId.get((Object)key);
        while (id == null) {
            BundleKey existing;
            id = (int)this.clusterIdSequence.incrementAndGet();
            Integer current = (Integer)this.clusterBundleToId.putIfAbsent((Object)key, (Object)id);
            if (current != null) {
                id = current;
            }
            if ((existing = (BundleKey)this.clusterIdToBundle.putIfAbsent((Object)id, (Object)key)) == null || existing.equals(key)) continue;
            log.warn("Conflict: bundle ID '{}' could not be assigned to '{}' because it is already assigned to '{}'. Discarding the ID and generating a new ID.", new Object[]{id, key, existing});
            id = null;
            this.clusterBundleToId.remove((Object)key);
        }
        this.registry.register(id, bundle);
    }

    private void registerMapping(Object key, Object value) {
        if (key instanceof BundleKey) {
            this.registry.registerMapping((Integer)value, (BundleKey)key, true);
        } else {
            this.registry.registerMapping((Integer)key, (BundleKey)value, false);
        }
    }

    private void synchronizeRegistry() {
        IMap<Integer, BundleKey> map = this.clusterIdToBundle;
        map.forEach(this::registerMapping);
    }

    private void unregisterBundle(@Nonnull Bundle bundle) {
        this.registry.unregister(bundle);
    }

    private class RegistryUpdatingEntryAddedListener
    implements EntryAddedListener<Object, Object> {
        private RegistryUpdatingEntryAddedListener() {
        }

        public void entryAdded(EntryEvent<Object, Object> event) {
            if (!event.getMember().localMember()) {
                OsgiClassLoaderRegistrySynchronizer.this.registerMapping(event.getKey(), event.getValue());
            }
        }
    }

    private class RegistryUpdatingMembershipListener
    implements MembershipListener {
        private RegistryUpdatingMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            OsgiClassLoaderRegistrySynchronizer.this.synchronizeRegistry();
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

