/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntity;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogAuthor;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.audit.ImmutableAuditLogEntry;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CrowdAuditLogMapper {
    private final I18nResolver i18nResolver;

    public CrowdAuditLogMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public AuditLogChangeset mapToAuditLogChangeset(AuditEvent auditEvent) {
        return new ImmutableAuditLogChangeset.Builder().setEventType(this.mapEventType(auditEvent.getActionI18nKey())).setEntities(this.mapEntities(auditEvent.getAffectedObjects())).addEntries(this.mapEntries(auditEvent.getChangedValues())).addEntries(this.mapAuditAttributes(auditEvent.getExtraAttributes())).setEventMessage(this.i18nResolver.getText(auditEvent.getActionI18nKey())).setAuthor((AuditLogAuthor)new ImmutableAuditLogAuthor(null, null, AuditLogAuthorType.APPLICATION)).build();
    }

    private AuditLogEventType mapEventType(String eventKey) {
        return switch (eventKey) {
            case "audit.logging.summary.client.authorization.successful" -> AuditLogEventType.CLIENT_AUTHORIZATION_SUCCESSFUL;
            case "audit.logging.summary.client.configuration.created" -> AuditLogEventType.CLIENT_CONFIGURATION_CREATED;
            case "audit.logging.summary.client.configuration.updated" -> AuditLogEventType.CLIENT_CONFIGURATION_UPDATED;
            case "audit.logging.summary.client.configuration.deleted" -> AuditLogEventType.CLIENT_CONFIGURATION_DELETED;
            case "audit.logging.summary.client.secret.refreshed" -> AuditLogEventType.CLIENT_SECRET_REFRESHED;
            case "audit.logging.summary.token.created" -> AuditLogEventType.TOKEN_CREATED;
            case "audit.logging.summary.token.revoked" -> AuditLogEventType.TOKEN_REVOKED;
            default -> AuditLogEventType.OTHER;
        };
    }

    private List<AuditLogEntity> mapEntities(List<AuditResource> auditResources) {
        return auditResources.stream().map(resource -> new ImmutableAuditLogEntity.Builder().setEntityType(this.mapEntityType(resource.getType())).setEntityName(resource.getName()).build()).collect(Collectors.toList());
    }

    private AuditLogEntityType mapEntityType(String key) {
        if ("USER".equals(key)) {
            return AuditLogEntityType.USER;
        }
        return AuditLogEntityType.OTHER;
    }

    private List<AuditLogEntry> mapAuditAttributes(Collection<AuditAttribute> auditAttributes) {
        return auditAttributes.stream().map(auditAttribute -> {
            String propertyName = StringUtils.isNotBlank((CharSequence)auditAttribute.getNameI18nKey()) ? auditAttribute.getNameI18nKey() : this.i18nResolver.getText(auditAttribute.getNameI18nKey());
            return new ImmutableAuditLogEntry.Builder().setPropertyName(propertyName).setNewValue(auditAttribute.getValue()).build();
        }).collect(Collectors.toList());
    }

    private List<AuditLogEntry> mapEntries(List<ChangedValue> changedValues) {
        return changedValues.stream().map(changedValue -> {
            String propertyName = StringUtils.isNotBlank((CharSequence)changedValue.getKey()) ? changedValue.getKey() : this.i18nResolver.getText(changedValue.getI18nKey());
            return new ImmutableAuditLogEntry.Builder().setPropertyName(propertyName).setOldValue(changedValue.getFrom()).setNewValue(changedValue.getTo()).build();
        }).collect(Collectors.toList());
    }
}

