/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.provider.core.client.dao.entity.AOClient;
import com.atlassian.oauth2.provider.core.security.ProviderPluginSecretServicePath;
import com.atlassian.oauth2.provider.core.settings.ProviderSettingsService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask01SecretService
implements PluginUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask01SecretService.class);
    private final ActiveObjects activeObjects;
    private final SecretService secretService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ProviderSettingsService defaultProviderSettingsService;

    public UpgradeTask01SecretService(ActiveObjects activeObjects, SecretService secretService, PluginSettingsFactory pluginSettingsFactory, ProviderSettingsService providerSettingsService) {
        this.activeObjects = activeObjects;
        this.secretService = secretService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.defaultProviderSettingsService = providerSettingsService;
    }

    public int getBuildNumber() {
        return 1;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrating client secrets to secret storage";
    }

    @Nullable
    public Collection<Message> doUpgrade() {
        this.activeObjects.executeInTransaction(() -> {
            this.migrateClientSecrets();
            this.migrateJwtSecret();
            return null;
        });
        return Collections.emptyList();
    }

    private void migrateClientSecrets() {
        if (SecretService.getState() == SecretServiceState.ENABLED) {
            logger.info("Secret service enabled, migrating client secrets");
            Arrays.stream((AOClient[])this.activeObjects.find(AOClient.class)).forEach(aoClient -> {
                logger.debug("Migrating client configuration [{}] to secret service", (Object)aoClient.getClientId());
                this.secretService.put(ProviderPluginSecretServicePath.clientSecretPath(aoClient.getClientId()), aoClient.getClientSecret());
                aoClient.setClientSecret("{ATL_SECURED}");
                aoClient.save();
            });
        } else {
            logger.info("Warning: secret service is disabled, skipping migration of client secrets");
        }
    }

    private void migrateJwtSecret() {
        if (SecretService.getState() == SecretServiceState.DISABLED) {
            logger.info("Warning: secret service is disabled, skipping migration of JWT secret");
        } else {
            PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
            if (pluginSettings.get(ProviderPluginSecretServicePath.jwtKeyPath()) == null) {
                logger.info("No JWT secret key found in plugin settings, skipping migration");
            } else {
                logger.debug("Migrating JWT secret to secret service");
                String jwtSecret = pluginSettings.get(ProviderPluginSecretServicePath.jwtKeyPath()).toString();
                if (!jwtSecret.equals("{ATL_SECURED}")) {
                    this.secretService.put(ProviderPluginSecretServicePath.jwtKeyPath(), jwtSecret);
                    pluginSettings.put(ProviderPluginSecretServicePath.jwtKeyPath(), (Object)"{ATL_SECURED}");
                    this.defaultProviderSettingsService.resetCachedValue();
                }
            }
        }
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.oauth2.oauth2-provider-plugin";
    }
}

