/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client;

import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientExpirationEvaluator;
import com.atlassian.oauth2.provider.core.client.util.ClientDateUtil;
import java.time.Duration;
import java.time.Instant;

public class DefaultClientExpirationEvaluator
implements ClientExpirationEvaluator {
    public boolean hasSoonToExpireLimitBreached(Client client, Duration threshold) {
        if (this.hasExpireLimitBreached(client)) {
            return false;
        }
        return this.hasLimitBreached(client.getCreatedDate(), this.calculateSoonToExpireInSeconds(this.resolveExpiryDuration(client.getExpiryDuration()), threshold.toSeconds()));
    }

    public boolean hasExpireLimitBreached(Client client) {
        return this.hasLimitBreached(client.getCreatedDate(), this.resolveExpiryDuration(client.getExpiryDuration()));
    }

    public long getDefaultClientCredentialExpiry() {
        return ClientDateUtil.getDefaultClientCredentialExpiry();
    }

    private boolean hasLimitBreached(long clientCreatedDateEpochMilli, long expiryInSeconds) {
        Instant breachingDate = Instant.ofEpochMilli(clientCreatedDateEpochMilli).plusSeconds(expiryInSeconds);
        return breachingDate.isBefore(Instant.now());
    }

    private Long resolveExpiryDuration(Duration duration) {
        if (duration == null) {
            return this.getDefaultClientCredentialExpiry();
        }
        return duration.toSeconds();
    }

    private long calculateSoonToExpireInSeconds(long clientSpecificExpiryInSeconds, long thresholdInSeconds) {
        return clientSpecificExpiryInSeconds - thresholdInSeconds;
    }
}

