/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client;

import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.api.client.CreateClientEntity;
import com.atlassian.oauth2.provider.api.client.UpdateClientEntity;
import com.atlassian.oauth2.provider.api.token.FlowType;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public class SystemAdminProtectedClientService
implements ClientService {
    private final PermissionEnforcer permissionEnforcer;
    private final ClientService delegate;

    public SystemAdminProtectedClientService(PermissionEnforcer permissionEnforcer, ClientService delegate) {
        this.permissionEnforcer = permissionEnforcer;
        this.delegate = delegate;
    }

    @Nonnull
    public Client create(@Nonnull String name, Scope scope, @Nonnull List<String> redirectUris) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.create(name, scope, redirectUris);
    }

    @Nonnull
    public Client create(CreateClientEntity client) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.create(client);
    }

    public Optional<Client> updateClient(@Nonnull String id, String name, String scope, @Nonnull List<String> redirectUris) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.updateClient(id, name, scope, redirectUris);
    }

    public Optional<Client> updateClient(UpdateClientEntity client) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.updateClient(client);
    }

    public Optional<Client> resetClientSecret(@Nonnull String clientId) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.resetClientSecret(clientId);
    }

    public Optional<Client> getById(@Nonnull String id) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.getById(id);
    }

    public Optional<Client> getByClientId(@Nonnull String clientId) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.getByClientId(clientId);
    }

    public Optional<Client> getByRotatedClientId(@Nonnull String clientId) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.getByRotatedClientId(clientId);
    }

    public Optional<Client> rotateClient(@Nonnull String clientId) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.rotateClient(clientId);
    }

    public List<String> findRedirectUrisByClientId(@Nonnull String clientId) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.findRedirectUrisByClientId(clientId);
    }

    public List<Client> list() {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.list();
    }

    public Optional<Client> removeById(@Nonnull String id) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.removeById(id);
    }

    public boolean isClientNameUnique(@Nullable String clientId, @Nonnull String clientName) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.isClientNameUnique(clientId, clientName);
    }

    public boolean isClientValid(@Nonnull String clientId, @Nonnull String clientSecret, @Nonnull FlowType flowType) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.isClientValid(clientId, clientSecret, flowType);
    }

    public boolean isClientSecretValid(@Nonnull String clientId, @Nonnull String clientSecret) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.isClientSecretValid(clientId, clientSecret);
    }

    public boolean isClientSecretValid(@Nonnull String clientId, @Nullable String clientSecret, @Nonnull FlowType flowType) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.isClientSecretValid(clientId, clientSecret, flowType);
    }

    public Optional<Client> revokeRotatedClientSecret(@Nonnull String id) {
        this.permissionEnforcer.enforceSystemAdmin();
        return this.delegate.revokeRotatedClientSecret(id);
    }
}

