/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.UpdateClientEntity;
import com.atlassian.oauth2.provider.core.client.dao.ClientDao;
import com.atlassian.oauth2.provider.core.client.dao.ClientEntity;
import com.atlassian.oauth2.provider.core.client.dao.RedirectUriDao;
import com.atlassian.oauth2.provider.core.client.dao.entity.AOClient;
import com.atlassian.oauth2.provider.core.client.util.ClientDateUtil;
import com.atlassian.oauth2.provider.core.client.util.GrantTypeUtil;
import com.atlassian.oauth2.provider.core.properties.SystemProperty;
import com.atlassian.oauth2.provider.core.security.ProviderPluginSecretServicePath;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientDao
implements ClientDao {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClientDao.class);
    private static final String WHERE_CLIENT_ID_EQUAL_TO = "CLIENT_ID = ?";
    private static final String WHERE_ROTATED_CLIENT_ID_EQUAL_TO = "ROTATED_CLIENT_ID = ?";
    private static final String WHERE_CLIENT_ID_NOT_EQUAL_TO = "CLIENT_ID <> ?";
    private static final String WHERE_NAME_EQUAL_TO = "NAME = ?";
    private static final String ORDER_BY_CLIENT_ID = "CLIENT_ID ASC";
    private final ActiveObjects activeObjects;
    private final ScopeResolver scopeResolver;
    private final RedirectUriDao redirectUriDao;
    private final SecretService secretService;

    public DefaultClientDao(ActiveObjects activeObjects, ScopeResolver scopeResolver, RedirectUriDao redirectUriDao, SecretService secretService) {
        this.activeObjects = activeObjects;
        this.scopeResolver = scopeResolver;
        this.redirectUriDao = redirectUriDao;
        this.secretService = secretService;
    }

    @Override
    @Nonnull
    public Client create(@Nonnull Client client) {
        Client clientToCreate = DefaultClientDao.copyClientWithAddedExpiryDuration(client);
        return (Client)this.activeObjects.executeInTransaction(() -> {
            logger.debug("Creating client {}", (Object)clientToCreate.getName());
            String sanitizedClientSecret = this.storeClientSecret(clientToCreate.getClientId(), clientToCreate.getClientSecret());
            this.activeObjects.create(AOClient.class, this.toClientMap(clientToCreate, sanitizedClientSecret));
            this.redirectUriDao.create(clientToCreate.getClientId(), clientToCreate.getRedirects());
            return clientToCreate;
        });
    }

    private static Client copyClientWithAddedExpiryDuration(@NotNull Client client) {
        return ClientEntity.builder().id(client.getId()).clientId(client.getClientId()).clientSecret(client.getClientSecret()).scope(client.getScope()).name(client.getName()).userKey(client.getUserKey()).redirects(client.getRedirects()).supportedGrantTypes(client.getSupportedGrantTypes()).expiryDuration(client.getExpiryDuration() != null ? client.getExpiryDuration() : SystemProperty.DEFAULT_CLIENT_CREDENTIALS_LIFETIME.getValue()).createdDate(client.getCreatedDate()).build();
    }

    @Override
    @Deprecated
    public Optional<Client> updateClient(@Nonnull String id, String name, String scope, @Nonnull List<String> newRedirectUris) {
        UpdateClientEntity clientUpdate = new UpdateClientEntity(id, name, scope, newRedirectUris, GrantType.CLIENT_DEFAULT_GRANT_TYPES, null);
        return this.updateClient(clientUpdate);
    }

    @Override
    public Optional<Client> updateClient(@Nonnull UpdateClientEntity client) {
        String id = client.id();
        String name = client.name();
        String scope = client.scope();
        List newRedirectUris = client.redirects();
        Set supportedGrantTypes = client.supportedGrantTypes();
        long expiryDuration = client.getExpiryDurationInSeconds() != null ? client.getExpiryDurationInSeconds().longValue() : SystemProperty.DEFAULT_CLIENT_CREDENTIALS_LIFETIME.getValue().toSeconds();
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findById(id).map(aoClient -> {
            boolean updateExpiryDuration;
            boolean updateGrantTypes;
            boolean updateUris;
            boolean updateScope;
            List<String> oldRedirectUris = this.redirectUriDao.findByClientId(aoClient.getClientId());
            boolean updateName = StringUtils.isNotEmpty((CharSequence)name);
            if (updateName) {
                logger.debug("Updating client name [{}] to [{}]", (Object)aoClient.getName(), (Object)name);
                aoClient.setName(name);
            }
            if (updateScope = StringUtils.isNotEmpty((CharSequence)scope)) {
                logger.debug("Updating scope from [{}] to [{}] for client [{}]", new Object[]{aoClient.getScope(), scope, aoClient.getName()});
                aoClient.setScope(scope);
            }
            if (updateUris = GrantType.isClientCredentialsOnly((Set)supportedGrantTypes) ? false : CollectionUtils.isNotEmpty((Collection)newRedirectUris)) {
                this.redirectUriDao.updateRedirectUris(aoClient.getClientId(), newRedirectUris);
            }
            boolean bl = updateGrantTypes = !GrantTypeUtil.fromCsv(aoClient.getGrantTypes()).equals(supportedGrantTypes);
            if (updateGrantTypes) {
                aoClient.setGrantTypes(GrantTypeUtil.toCsv(supportedGrantTypes));
            }
            boolean bl2 = updateExpiryDuration = !Objects.equals(aoClient.getExpiryDuration(), expiryDuration);
            if (updateExpiryDuration) {
                aoClient.setExpiryDuration(expiryDuration);
            }
            if (updateName || updateScope || updateGrantTypes || updateExpiryDuration) {
                logger.debug("Saving updates for client [{}]", (Object)aoClient.getName());
                aoClient.save();
            }
            return this.toEntity((AOClient)aoClient, updateUris ? newRedirectUris : oldRedirectUris);
        }));
    }

    @Override
    public Optional<Client> resetClientSecret(@Nonnull String clientId, @Nonnull String regeneratedClientSecret) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findByClientId(clientId).map(aoClient -> {
            List<String> redirects = this.redirectUriDao.findByClientId(clientId);
            logger.debug("Resetting client secret for client [{}]", (Object)aoClient.getName());
            String clientSecret = this.storeClientSecret(aoClient.getClientId(), regeneratedClientSecret);
            aoClient.setClientSecret(clientSecret);
            aoClient.save();
            return this.toEntity((AOClient)aoClient, redirects);
        }));
    }

    @Override
    public Optional<Client> revokeRotatedClientSecret(@Nonnull String id) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findById(id).map(aoClient -> {
            String rotatedClientId = aoClient.getRotatedClientId();
            if (rotatedClientId == null) {
                logger.debug("No rotated client secret to revoke for client [{}]", (Object)aoClient.getName());
                return this.toEntity((AOClient)aoClient, this.redirectUriDao.findByClientId(aoClient.getClientId()));
            }
            logger.debug("Removing redirect URIs for client id [{}]", (Object)rotatedClientId);
            this.redirectUriDao.removeByClientId(rotatedClientId);
            logger.debug("Removing client id and secret from secret service [{}]", (Object)aoClient.getName());
            this.removeClientSecret(rotatedClientId);
            logger.debug("Removing rotated client id and secret from AOClient for id [{}]", (Object)id);
            aoClient.setRotatedClientId(null);
            aoClient.setRotatedClientSecret(null);
            aoClient.save();
            return this.toEntity((AOClient)aoClient, this.redirectUriDao.findByClientId(aoClient.getClientId()));
        }));
    }

    @Override
    public Optional<Client> rotateClient(@Nonnull String clientId, @Nonnull String newClientId, @Nonnull String newClientSecret) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findByClientId(clientId).map(aoClient -> {
            List<String> redirects = this.redirectUriDao.findByClientId(clientId);
            logger.debug("Resetting client id and secret for client [{}]", (Object)aoClient.getName());
            if (aoClient.getRotatedClientId() != null) {
                this.secretService.delete(ProviderPluginSecretServicePath.clientSecretPath(aoClient.getRotatedClientId()));
            }
            aoClient.setRotatedClientId(aoClient.getClientId());
            aoClient.setRotatedClientSecret(aoClient.getClientSecret());
            aoClient.setRotatedCreatedDate(aoClient.getCreatedDate());
            String clientSecret = this.storeClientSecret(newClientId, newClientSecret);
            aoClient.setClientId(newClientId);
            aoClient.setClientSecret(clientSecret);
            aoClient.setCreatedDate(ClientDateUtil.nowInMillis());
            aoClient.setLastRotationDate(ClientDateUtil.nowInMillis());
            aoClient.save();
            this.redirectUriDao.create(newClientId, redirects);
            return this.toEntity((AOClient)aoClient, redirects);
        }));
    }

    @Override
    public Optional<Client> removeById(@Nonnull String id) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findById(id).map(aoClient -> {
            List<String> redirects = this.redirectUriDao.findByClientId(aoClient.getClientId());
            ClientEntity entityDeleted = this.toEntity((AOClient)aoClient, redirects);
            logger.debug("Removing client [{}]", (Object)aoClient.getName());
            this.activeObjects.delete(new RawEntity[]{aoClient});
            this.redirectUriDao.removeByClientId(aoClient.getClientId());
            this.secretService.delete(ProviderPluginSecretServicePath.clientSecretPath(aoClient.getClientId()));
            return entityDeleted;
        }));
    }

    @Override
    @Nonnull
    public Optional<Client> getById(@Nonnull String id) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findById(id).map(aoClient -> {
            logger.debug("Found client associated with id [{}]", (Object)id);
            List<String> redirects = this.redirectUriDao.findByClientId(aoClient.getClientId());
            return this.toEntity((AOClient)aoClient, redirects);
        }));
    }

    @Override
    @Nonnull
    public Optional<Client> getByClientId(@Nonnull String clientId) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findByClientId(clientId).map(aoClient -> {
            List<String> redirects = this.redirectUriDao.findByClientId(aoClient.getClientId());
            return this.toEntity((AOClient)aoClient, redirects);
        }));
    }

    @Override
    @Nonnull
    public Optional<Client> getByRotatedClientId(@Nonnull String clientId) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findByRotatedClientId(clientId).map(aoClient -> {
            List<String> redirects = this.redirectUriDao.findByClientId(aoClient.getClientId());
            return this.toEntity((AOClient)aoClient, redirects);
        }));
    }

    @Override
    @Nonnull
    public Optional<String> getClientIdById(@Nonnull String id) {
        return (Optional)this.activeObjects.executeInTransaction(() -> Optional.ofNullable(this.findById(id).get().getClientId()));
    }

    @Override
    public boolean isClientNameUnique(@Nullable String id, @Nonnull String name) {
        return (Boolean)this.activeObjects.executeInTransaction(() -> {
            Query query = Query.select((String)"CLIENT_ID");
            Object[] params = new Object[]{name.trim()};
            if (id == null) {
                query.setWhereClause(WHERE_NAME_EQUAL_TO);
                query.setWhereParams(params);
            } else {
                query.setWhereClause("NAME = ? AND CLIENT_ID <> ?");
                query.setWhereParams(ArrayUtils.add((Object[])params, (Object)id));
            }
            return this.activeObjects.count(AOClient.class, query) == 0;
        });
    }

    private Optional<AOClient> findById(@Nonnull String id) {
        return Optional.ofNullable((AOClient)this.activeObjects.get(AOClient.class, (Object)id));
    }

    private Optional<AOClient> findByClientId(@Nonnull String clientId) {
        return this.findByClientId(clientId, WHERE_CLIENT_ID_EQUAL_TO);
    }

    private Optional<AOClient> findByRotatedClientId(@Nonnull String clientId) {
        return this.findByClientId(clientId, WHERE_ROTATED_CLIENT_ID_EQUAL_TO);
    }

    private Optional<AOClient> findByClientId(@Nonnull String clientId, String clause) {
        AOClient[] entities = (AOClient[])this.activeObjects.find(AOClient.class, Query.select().where(clause, new Object[]{clientId}));
        if (entities.length > 0) {
            logger.debug("Found client associated with client id [{}]", (Object)clientId);
            return Optional.of(entities[0]);
        }
        logger.debug("Failed to find a client associated with client id [{}]", (Object)clientId);
        return Optional.empty();
    }

    @Override
    @Nonnull
    public List<Client> list() {
        return (List)this.activeObjects.executeInTransaction(() -> Arrays.stream((AOClient[])this.activeObjects.find(AOClient.class, Query.select().order(ORDER_BY_CLIENT_ID))).map(aoClient -> {
            List<String> redirects = this.redirectUriDao.findByClientId(aoClient.getClientId());
            return this.toEntity((AOClient)aoClient, redirects);
        }).collect(Collectors.toList()));
    }

    private ClientEntity toEntity(AOClient aoClient, List<String> redirects) {
        String rotatedClientSecret = aoClient.getRotatedClientId() != null && aoClient.getRotatedClientSecret() != null ? this.getClientSecret(aoClient.getRotatedClientId(), aoClient.getRotatedClientSecret()) : null;
        Set<GrantType> grantTypes = GrantTypeUtil.fromCsv(aoClient.getGrantTypes());
        Duration expiryDuration = aoClient.getExpiryDuration() == null ? SystemProperty.DEFAULT_CLIENT_CREDENTIALS_LIFETIME.getValue() : Duration.ofSeconds(aoClient.getExpiryDuration());
        return ClientEntity.builder().id(aoClient.getId()).clientId(aoClient.getClientId()).clientSecret(this.getClientSecret(aoClient.getClientId(), aoClient.getClientSecret())).name(aoClient.getName()).userKey(aoClient.getUserKey()).redirects(redirects).scope(this.scopeResolver.getScope(aoClient.getScope())).createdDate(aoClient.getCreatedDate()).lastRotationDate(aoClient.getLastRotationDate()).rotatedClientId(aoClient.getRotatedClientId()).rotatedClientSecret(rotatedClientSecret).rotatedCreatedDate(aoClient.getRotatedCreatedDate()).supportedGrantTypes(grantTypes).expiryDuration(expiryDuration).build();
    }

    private ImmutableMap<String, Object> toClientMap(Client client, String clientSecret) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"ID", (Object)client.getId()).put((Object)"CLIENT_ID", (Object)client.getClientId()).put((Object)"NAME", (Object)client.getName()).put((Object)"USER_KEY", (Object)client.getUserKey()).put((Object)"SCOPE", (Object)client.getScope().toString()).put((Object)"CLIENT_SECRET", (Object)clientSecret).put((Object)"CREATED_DATE", (Object)client.getCreatedDate()).put((Object)"GRANT_TYPES", (Object)GrantTypeUtil.toCsv(client.getSupportedGrantTypes()));
        if (client.getExpiryDuration() != null) {
            builder.put((Object)"EXPIRY_DURATION", (Object)client.getExpiryDuration().getSeconds());
        } else {
            builder.put((Object)"EXPIRY_DURATION", (Object)SystemProperty.DEFAULT_CLIENT_CREDENTIALS_LIFETIME.getValue().getSeconds());
        }
        return builder.build();
    }

    private String storeClientSecret(String clientId, String clientSecret) {
        if (this.isSecretServiceEnabled()) {
            this.secretService.put(ProviderPluginSecretServicePath.clientSecretPath(clientId), clientSecret);
            return "{ATL_SECURED}";
        }
        logger.debug("Warning: secret service has been disabled, skipping encryption of client secret");
        return clientSecret;
    }

    private void removeClientSecret(String clientId) {
        try {
            this.secretService.delete(ProviderPluginSecretServicePath.clientSecretPath(clientId));
        }
        catch (SecretServiceException ex) {
            logger.error("Error while deleting client secret for client id [{}].", (Object)clientId, (Object)ex);
        }
    }

    private String getClientSecret(String clientId, String clientSecret) {
        if (this.isSecretServiceEnabled()) {
            Optional maybeClientSecret = this.secretService.get(ProviderPluginSecretServicePath.clientSecretPath(clientId));
            if (maybeClientSecret.isEmpty()) {
                logger.error("Failed to retrieve secrets from secret service for client configuration id [{}].", (Object)clientId);
            }
            return maybeClientSecret.orElse("");
        }
        if (clientSecret.equals("{ATL_SECURED}")) {
            throw new SecretServiceException("Secret service is disabled, but client secret is marked as secured.");
        }
        return clientSecret;
    }

    private boolean isSecretServiceEnabled() {
        return SecretService.getState() == SecretServiceState.ENABLED;
    }
}

