/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client.dao.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.provider.core.client.dao.entity.AOClient;
import com.atlassian.oauth2.provider.core.client.util.GrantTypeUtil;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AOClientPopulateDefaultGrantTypesUpgradeTask
implements ActiveObjectsUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(AOClientPopulateDefaultGrantTypesUpgradeTask.class);
    private static final String CLIENT_DEFAULT_GRANT_TYPES_CSV = GrantTypeUtil.toCsv(GrantType.CLIENT_DEFAULT_GRANT_TYPES);
    public static final int PAGE_SIZE = 500;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        boolean fullPageRetrieved;
        logger.info("Upgrading AOClient to version 2");
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)"This task can only upgrade from version 1 to 2");
        ao.migrate(new Class[]{AOClient.class});
        AtomicInteger pageNumber = new AtomicInteger();
        pageNumber.set(0);
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction(() -> {
            AOClient[] existingClients = (AOClient[])ao.find(AOClient.class, Query.select().limit(500).offset(500 * pageNumber.get()));
            logger.info("Processing page {} with {} clients", (Object)pageNumber.get(), (Object)existingClients.length);
            for (AOClient existingClient : existingClients) {
                existingClient.setGrantTypes(CLIENT_DEFAULT_GRANT_TYPES_CSV);
                existingClient.save();
            }
            pageNumber.set(pageNumber.get() + 1);
            return existingClients.length == 500;
        })).booleanValue()) {
        }
        logger.info("Finished upgrading AOClient to version 2");
    }
}

