/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client.util;

import com.atlassian.oauth2.provider.core.properties.SystemProperty;
import java.time.Duration;
import java.time.Instant;

public final class ClientDateUtil {
    public static final long MAX_DURATION = Duration.ofDays(730L).toSeconds();

    private ClientDateUtil() {
    }

    public static boolean hasExpired(long clientCreatedDate, Duration clientExpiryDurationInSeconds) {
        long expireAt = ClientDateUtil.calculateExpirationDateInMillis(clientCreatedDate, clientExpiryDurationInSeconds);
        return expireAt - ClientDateUtil.nowInMillis() < 0L;
    }

    private static long calculateExpirationDateInMillis(long clientCreatedDate, Duration clientExpiryDurationInSeconds) {
        long clientDuration = clientExpiryDurationInSeconds != null ? clientExpiryDurationInSeconds.getSeconds() : SystemProperty.DEFAULT_CLIENT_CREDENTIALS_LIFETIME.getValue().getSeconds();
        clientDuration = Math.min(MAX_DURATION, clientDuration);
        Instant expiryDate = Instant.ofEpochMilli(clientCreatedDate).plusSeconds(clientDuration);
        return expiryDate.toEpochMilli();
    }

    public static long nowInMillis() {
        return Instant.now().toEpochMilli();
    }

    public static long getDefaultClientCredentialExpiry() {
        long systemConfiguredDuration = SystemProperty.DEFAULT_CLIENT_CREDENTIALS_LIFETIME.getValue().getSeconds();
        return Math.min(MAX_DURATION, systemConfiguredDuration);
    }
}

