/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client.util;

import com.atlassian.oauth2.client.api.storage.config.GrantType;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class GrantTypeUtil {
    @Nonnull
    public static String toCsv(Set<GrantType> supportedGrantTypes) {
        if (supportedGrantTypes == null || supportedGrantTypes.isEmpty()) {
            throw new IllegalArgumentException("Grant types cannot be null or empty");
        }
        return supportedGrantTypes.stream().map(GrantType::getName).collect(Collectors.joining(","));
    }

    @Nonnull
    public static Set<GrantType> fromCsv(String grantTypesText) {
        if (grantTypesText == null || grantTypesText.trim().isEmpty()) {
            throw new IllegalArgumentException("Grant types cannot be null or empty");
        }
        return Arrays.stream(grantTypesText.trim().split(",")).map(grantType -> (GrantType)GrantType.getByName((String)grantType).orElseThrow(() -> new IllegalArgumentException("Invalid grant type: " + grantType))).collect(Collectors.toSet());
    }
}

