/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.credentials;

import javax.crypto.KeyGenerator;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;

public class ClientCredentialsGenerator {
    public String generate(Length length) {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(length.keysize);
        return Hex.encodeHexString((byte[])keyGenerator.generateKey().getEncoded());
    }

    public static boolean isValidGeneratedKey(String input, Length length) {
        int expectedBytes = length.keysize / 8;
        int expectedHexLength = expectedBytes * 2;
        if (input.isBlank() || input.length() != expectedHexLength) {
            return false;
        }
        return input.matches("[0-9a-fA-F]{" + expectedHexLength + "}");
    }

    @Generated
    public ClientCredentialsGenerator() {
    }

    public static enum Length {
        THIRTY_TWO(128),
        FORTY_EIGHT(192),
        SIXTY_FOUR(256);

        private final int keysize;

        private Length(int keysize) {
            this.keysize = keysize;
        }
    }
}

