/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import com.atlassian.oauth2.provider.core.event.authorization.IncomingClientConnectionEvent;
import com.atlassian.oauth2.provider.core.event.client.ClientConfigurationCreatedEvent;
import com.atlassian.oauth2.provider.core.event.client.ClientConfigurationDeletedEvent;
import com.atlassian.oauth2.provider.core.event.client.ClientConfigurationUpdatedEvent;
import com.atlassian.oauth2.provider.core.event.client.ClientRotatedEvent;
import com.atlassian.oauth2.provider.core.event.client.ClientSecretRefreshEvent;
import com.atlassian.oauth2.provider.core.event.client.RotatedClientRevokedEvent;
import com.atlassian.oauth2.provider.core.event.token.AllRefreshTokensRevokedEvent;
import com.atlassian.oauth2.provider.core.event.token.TokenCreatedEvent;
import com.atlassian.oauth2.provider.core.event.token.TokenRevokedEvent;

public class OAuth2ProviderEventPublisher {
    private final EventPublisher eventPublisher;

    public OAuth2ProviderEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void publishTokenCreatedEvent(String clientId, RefreshToken refreshToken) {
        this.eventPublisher.publish((Object)new TokenCreatedEvent(clientId, refreshToken));
    }

    public void publishTokenRevokedEvent(String clientId, String userKey) {
        this.eventPublisher.publish((Object)new TokenRevokedEvent(clientId, userKey));
    }

    public void publishClientConfigurationCreatedEvent(Client client) {
        this.eventPublisher.publish((Object)new ClientConfigurationCreatedEvent(client));
    }

    public void publishClientConfigurationDeletedEvent(Client client) {
        this.eventPublisher.publish((Object)new ClientConfigurationDeletedEvent(client));
    }

    public void publishClientConfigurationUpdatedEvent(Client oldClient, Client newClient) {
        this.eventPublisher.publish((Object)new ClientConfigurationUpdatedEvent(oldClient, newClient));
    }

    public void publishClientSecretRefreshedEvent(Client client) {
        this.eventPublisher.publish((Object)new ClientSecretRefreshEvent(client));
    }

    public void publishRotatedClientRevokedEvent(Client client) {
        this.eventPublisher.publish((Object)new RotatedClientRevokedEvent(client));
    }

    public void publishClientRotatedEvent(Client client) {
        this.eventPublisher.publish((Object)new ClientRotatedEvent(client.getClientId()));
    }

    public void publishClientIncomingConnectionEvent() {
        this.eventPublisher.publish((Object)new IncomingClientConnectionEvent());
    }

    public void publishAllRefreshTokensRevokedEvent() {
        this.eventPublisher.publish((Object)new AllRefreshTokensRevokedEvent());
    }
}

