/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.token.refresh.dao;

import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import com.atlassian.oauth2.scopes.api.Scope;
import jakarta.annotation.Nonnull;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public record RefreshTokenEntity(@Nonnull String id, @Nonnull String accessTokenId, @Nonnull String clientId, @Nonnull String userKey, @Nonnull Set<Scope> scopes, @Nonnull String authorizationCode, @Nonnull Long authorizationDate, @Nonnull Long createdAt, Integer refreshCount) implements RefreshToken
{
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getAccessTokenId() {
        return this.accessTokenId;
    }

    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @NotNull
    public Scope getScope() {
        return (Scope)this.scopes.stream().findFirst().orElseThrow();
    }

    @Nonnull
    public Set<Scope> getScopes() {
        return this.scopes;
    }

    @Nonnull
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Nonnull
    public Long getAuthorizationDate() {
        return this.authorizationDate;
    }

    @Nonnull
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Integer getRefreshCount() {
        return this.refreshCount;
    }

    @Generated
    public static RefreshTokenEntityBuilder builder() {
        return new RefreshTokenEntityBuilder();
    }

    @Generated
    public RefreshTokenEntityBuilder toBuilder() {
        return new RefreshTokenEntityBuilder().id(this.id).accessTokenId(this.accessTokenId).clientId(this.clientId).userKey(this.userKey).scopes(this.scopes).authorizationCode(this.authorizationCode).authorizationDate(this.authorizationDate).createdAt(this.createdAt).refreshCount(this.refreshCount);
    }

    @Generated
    public static class RefreshTokenEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String accessTokenId;
        @Generated
        private String clientId;
        @Generated
        private String userKey;
        @Generated
        private Set<Scope> scopes;
        @Generated
        private String authorizationCode;
        @Generated
        private Long authorizationDate;
        @Generated
        private Long createdAt;
        @Generated
        private Integer refreshCount;

        @Generated
        RefreshTokenEntityBuilder() {
        }

        @Generated
        public RefreshTokenEntityBuilder id(@Nonnull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder accessTokenId(@Nonnull String accessTokenId) {
            if (accessTokenId == null) {
                throw new NullPointerException("accessTokenId is marked non-null but is null");
            }
            this.accessTokenId = accessTokenId;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder clientId(@Nonnull String clientId) {
            if (clientId == null) {
                throw new NullPointerException("clientId is marked non-null but is null");
            }
            this.clientId = clientId;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder userKey(@Nonnull String userKey) {
            if (userKey == null) {
                throw new NullPointerException("userKey is marked non-null but is null");
            }
            this.userKey = userKey;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder scopes(@Nonnull Set<Scope> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder authorizationCode(@Nonnull String authorizationCode) {
            if (authorizationCode == null) {
                throw new NullPointerException("authorizationCode is marked non-null but is null");
            }
            this.authorizationCode = authorizationCode;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder authorizationDate(@Nonnull Long authorizationDate) {
            if (authorizationDate == null) {
                throw new NullPointerException("authorizationDate is marked non-null but is null");
            }
            this.authorizationDate = authorizationDate;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder createdAt(@Nonnull Long createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public RefreshTokenEntityBuilder refreshCount(Integer refreshCount) {
            this.refreshCount = refreshCount;
            return this;
        }

        @Generated
        public RefreshTokenEntity build() {
            return new RefreshTokenEntity(this.id, this.accessTokenId, this.clientId, this.userKey, this.scopes, this.authorizationCode, this.authorizationDate, this.createdAt, this.refreshCount);
        }

        @Generated
        public String toString() {
            return "RefreshTokenEntity.RefreshTokenEntityBuilder(id=" + this.id + ", accessTokenId=" + this.accessTokenId + ", clientId=" + this.clientId + ", userKey=" + this.userKey + ", scopes=" + String.valueOf(this.scopes) + ", authorizationCode=" + this.authorizationCode + ", authorizationDate=" + this.authorizationDate + ", createdAt=" + this.createdAt + ", refreshCount=" + this.refreshCount + ")";
        }
    }
}

