/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.user;

import com.atlassian.oauth2.provider.core.user.ActiveUserNotFoundException;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.annotation.Nonnull;
import java.security.Principal;
import java.util.Optional;

public class SalUserProvider
implements ProductUserProvider {
    private final UserManager userManager;

    public SalUserProvider(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    @Nonnull
    public Optional<? extends Principal> getActiveUserByKey(@Nonnull UserKey userkey) {
        return Optional.ofNullable(this.userManager.getUserProfile(userkey)).map(user -> () -> ((UserProfile)user).getUsername());
    }

    @Override
    public boolean isUserDeleted(@Nonnull String userKey) throws ActiveUserNotFoundException {
        return this.getActiveUserByKey(new UserKey(userKey)).isEmpty();
    }

    @Override
    @Nonnull
    public Optional<UserKey> getKeyForUsername(@Nonnull String username) {
        return Optional.of(new UserKey(username));
    }

    @Override
    @Nonnull
    public Optional<String> getUsernameForKey(@Nonnull UserKey userKey) {
        return Optional.of(userKey.getStringValue());
    }
}

