/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.data.themes;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.lookandfeel.LookAndFeelConfiguration;
import com.atlassian.oauth2.provider.data.themes.ProductCustomTheme;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Strings;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdCustomThemeFactory
extends ProductCustomThemeFactory {
    private static final Logger log = LoggerFactory.getLogger(CrowdCustomThemeFactory.class);
    private final PropertyManager propertyManager;
    private final ApplicationProperties applicationProperties;

    public CrowdCustomThemeFactory(PropertyManager propertyManager, ApplicationProperties applicationProperties) {
        this.propertyManager = propertyManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public ProductCustomTheme get() {
        return this.getConfiguration().map(configuration -> new ProductCustomTheme("#0747a6", this.getLogoUrl((LookAndFeelConfiguration)configuration), configuration.isShowLogo())).orElse(ProductCustomTheme.DEFAULT_THEME);
    }

    private Optional<LookAndFeelConfiguration> getConfiguration() {
        try {
            return this.propertyManager.getLookAndFeelConfiguration();
        }
        catch (PropertyManagerException e) {
            log.warn("Could not get look and feel configuration", (Throwable)e);
            return Optional.empty();
        }
    }

    private String getLogoUrl(LookAndFeelConfiguration lookAndFeelConfiguration) {
        return Optional.ofNullable(Strings.emptyToNull((String)lookAndFeelConfiguration.getCustomLogoId())).map(logoId -> this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/logo/" + logoId).orElse("");
    }
}

