/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Duration;

public class DurationIso8601Deserializer
extends JsonDeserializer<Duration> {
    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getText();
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Duration.parse(value);
        }
        catch (Exception e) {
            throw ctxt.weirdStringException(value, Duration.class, "Expected ISO-8601 duration format");
        }
    }
}

