/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.model;

import com.atlassian.oauth2.common.rest.validator.ErrorCollection;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@XmlRootElement
public class RestErrorCollection {
    @JsonProperty
    private List<String> errors;
    @JsonProperty
    private Map<String, List<String>> fieldErrors;

    public RestErrorCollection(@Nonnull ErrorCollection errorCollection) {
        this(errorCollection.getErrors(), errorCollection.getFieldErrors());
    }

    public RestErrorCollection(@Nonnull List<String> errors, @Nonnull Map<String, List<String>> fieldErrors) {
        this.errors = ImmutableList.copyOf(errors);
        this.fieldErrors = ImmutableMap.copyOf((Map)Maps.transformValues(fieldErrors, ImmutableList::copyOf));
    }

    @Generated
    public List<String> getErrors() {
        return this.errors;
    }

    @Generated
    public Map<String, List<String>> getFieldErrors() {
        return this.fieldErrors;
    }

    @JsonProperty
    @Generated
    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @JsonProperty
    @Generated
    public void setFieldErrors(Map<String, List<String>> fieldErrors) {
        this.fieldErrors = fieldErrors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestErrorCollection)) {
            return false;
        }
        RestErrorCollection other = (RestErrorCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        Map<String, List<String>> this$fieldErrors = this.getFieldErrors();
        Map<String, List<String>> other$fieldErrors = other.getFieldErrors();
        return !(this$fieldErrors == null ? other$fieldErrors != null : !((Object)this$fieldErrors).equals(other$fieldErrors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestErrorCollection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        Map<String, List<String>> $fieldErrors = this.getFieldErrors();
        result = result * 59 + ($fieldErrors == null ? 43 : ((Object)$fieldErrors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestErrorCollection(errors=" + String.valueOf(this.getErrors()) + ", fieldErrors=" + String.valueOf(this.getFieldErrors()) + ")";
    }

    @Generated
    public RestErrorCollection() {
    }
}

