/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.oauth2.provider.rest.model.PageDto;
import com.atlassian.oauth2.provider.rest.model.ScopeDto;
import com.atlassian.oauth2.provider.rest.service.ScopeRestService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="internal/scopes")
@Produces(value={"application/json"})
@Singleton
public class AvailableScopesResource {
    private static final Logger logger = LoggerFactory.getLogger(AvailableScopesResource.class);
    private final ScopeRestService scopeRestService;

    @Inject
    public AvailableScopesResource(ScopeRestService scopeRestService) {
        this.scopeRestService = scopeRestService;
    }

    @GET
    @Path(value="/available")
    public PageDto<ScopeDto> getAvailableScopes(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="grant_types") Set<String> grantTypes) {
        logger.debug("Getting available scopes with start {} and limit {}", (Object)start, (Object)limit);
        return this.scopeRestService.getAvailableScopes(start, limit, grantTypes);
    }
}

