/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.annotations.PublicApi;
import com.atlassian.oauth2.provider.rest.exception.ClientNotFoundException;
import com.atlassian.oauth2.provider.rest.exception.ValidationException;
import com.atlassian.oauth2.provider.rest.model.RestClientEntity;
import com.atlassian.oauth2.provider.rest.service.ClientRestService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="client")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
@SystemAdminOnly
public class ClientResource {
    private static final Logger logger = LoggerFactory.getLogger(ClientResource.class);
    private final ClientRestService clientRestService;

    @Inject
    public ClientResource(ClientRestService clientRestService) {
        this.clientRestService = clientRestService;
    }

    @GET
    @PublicApi
    public Response getClients() throws ValidationException {
        logger.debug("Retrieving all clients");
        return Response.ok(this.clientRestService.list()).build();
    }

    @POST
    @PublicApi
    public Response createClient(RestClientEntity client) throws ValidationException {
        logger.debug("Creating client");
        return Response.ok((Object)this.clientRestService.create(client)).build();
    }

    @PUT
    @Path(value="/{id}")
    @PublicApi
    public Response updateClient(@PathParam(value="id") String id, RestClientEntity client) throws ValidationException, ClientNotFoundException {
        logger.debug("Updating client with id: [{}]", (Object)id);
        this.clientRestService.update(id, client);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/reset/{clientId}")
    @PublicApi
    public Response resetClientSecret(@PathParam(value="clientId") String clientId) throws ClientNotFoundException {
        logger.debug("Resetting client secret associated with client id: [{}]", (Object)clientId);
        return Response.ok((Object)this.clientRestService.resetClientSecret(clientId)).build();
    }

    @DELETE
    @Path(value="/revoke/rotated/{id}")
    @PublicApi
    public Response revokeRotatedClientSecret(@PathParam(value="id") String id) throws ClientNotFoundException {
        logger.debug("Resetting rotated client secret associated with client entity id: [{}]", (Object)id);
        return Response.ok((Object)this.clientRestService.revokeRotatedClientSecret(id)).build();
    }

    @GET
    @Path(value="/{id}")
    @PublicApi
    public Response getClient(@PathParam(value="id") String id) throws ClientNotFoundException {
        logger.debug("Retrieving client associated with id: [{}]", (Object)id);
        return Response.ok((Object)this.clientRestService.get(id)).build();
    }

    @DELETE
    @Path(value="/{id}")
    @PublicApi
    public Response deleteClient(@PathParam(value="id") String id) throws ValidationException, ClientNotFoundException {
        logger.debug("Deleting client with id: [{}]", (Object)id);
        return Response.ok((Object)this.clientRestService.delete(id)).build();
    }
}

