/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.oauth2.provider.rest.exception.BadRequestException;
import com.atlassian.oauth2.provider.rest.exception.InvalidClientException;
import com.atlassian.oauth2.provider.rest.model.RevokeRequestFormParams;
import com.atlassian.oauth2.provider.rest.service.RevokeTokenService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserKey;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="revoke")
@Produces(value={"application/json"})
@Singleton
public class RevokeResource {
    private static final Logger logger = LoggerFactory.getLogger(RevokeResource.class);
    private final RevokeTokenService revokeTokenService;

    @Inject
    public RevokeResource(RevokeTokenService revokeTokenService) {
        this.revokeTokenService = revokeTokenService;
    }

    @POST
    @XsrfProtectionExcluded
    @UnrestrictedAccess
    @PublicApi
    public Response revokeToken(@FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint, @FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret) throws BadRequestException, InvalidClientException {
        logger.debug("Revoking token associated with client id [{}]", (Object)clientId);
        RevokeRequestFormParams formParams = RevokeRequestFormParams.builder().token(token).clientId(clientId).clientSecret(clientSecret).tokenTypeHint(tokenTypeHint).build();
        this.revokeTokenService.revokeToken(formParams);
        return Response.ok().build();
    }

    @POST
    @XsrfProtectionExcluded
    @Path(value="/jwt/{jwt}")
    public Response revokeJwt(@PathParam(value="jwt") String jwt) throws BadRequestException {
        logger.debug("Revoking access and refresh tokens matching jwt token [{}]", (Object)jwt);
        this.revokeTokenService.revokeJwt(jwt);
        return Response.ok().build();
    }

    @LicensedOnly
    @POST
    @XsrfProtectionExcluded
    @Path(value="/{id}")
    public Response revokeTokenWithId(@PathParam(value="id") String tokenId) throws BadRequestException {
        logger.debug("Revoking token associated with token id [{}]", (Object)tokenId);
        this.revokeTokenService.revokeToken(tokenId);
        return Response.ok().build();
    }

    @LicensedOnly
    @POST
    @Path(value="refresh-token")
    public Response revokeAllRefreshTokensForCurrentUser() {
        this.revokeTokenService.revokeAllRefreshTokensForCurrentUser();
        return Response.ok().build();
    }

    @SystemAdminOnly
    @POST
    @Path(value="refresh-token/all/{userKey}")
    public Response revokeAllRefreshTokensByUser(@PathParam(value="userKey") String userKey) {
        this.revokeTokenService.revokeAllRefreshTokensForUser(new UserKey(userKey));
        return Response.ok().build();
    }

    @SystemAdminOnly
    @POST
    @Path(value="refresh-token/all")
    public Response revokeAllUserRefreshTokens() {
        this.revokeTokenService.revokeAllRefreshTokens();
        return Response.ok().build();
    }
}

