/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.oauth2.provider.core.settings.ProviderSettingsService;
import com.atlassian.oauth2.provider.rest.exception.InvalidGrantException;
import com.atlassian.oauth2.provider.rest.model.TokenRequestFormParams;
import com.atlassian.oauth2.provider.rest.service.TokenRestService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="token")
@Consumes
@Produces(value={"application/json"})
@Singleton
public class TokenResource {
    private static final Logger logger = LoggerFactory.getLogger(TokenResource.class);
    private final TokenRestService tokenRestService;
    private final ProviderSettingsService providerSettingsService;

    @Inject
    public TokenResource(TokenRestService tokenRestService, ProviderSettingsService providerSettingsService) {
        this.tokenRestService = tokenRestService;
        this.providerSettingsService = providerSettingsService;
    }

    @XsrfProtectionExcluded
    @UnrestrictedAccess
    @POST
    @PublicApi
    public Response createToken(@FormParam(value="grant_type") String grantType, @FormParam(value="code") String code, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret, @FormParam(value="scope") String scope, @FormParam(value="refresh_token") String refreshToken, @FormParam(value="code_verifier") String codeVerifier) throws InvalidGrantException, InterruptedException {
        logger.debug("Creating token for client id [{}]", (Object)clientId);
        TokenRequestFormParams formParams = TokenRequestFormParams.builder().grantType(grantType).code(code).redirectUri(redirectUri).clientId(clientId).clientSecret(clientSecret).scope(scope).refreshToken(refreshToken).codeVerifier(codeVerifier).build();
        return Response.ok((Object)this.tokenRestService.create(formParams)).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache").build();
    }

    @XsrfProtectionExcluded
    @SystemAdminOnly
    @POST
    @Path(value="/jwt/reset")
    @PublicApi
    public Response reset() {
        logger.debug("Resetting JWT secret configured in plugin settings");
        this.providerSettingsService.reset();
        return Response.ok().build();
    }
}

