/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.oauth2.provider.api.external.OAuth2AuthorizationServerMetadata;
import com.atlassian.oauth2.provider.api.external.OAuth2ProviderService;
import com.atlassian.oauth2.provider.rest.model.RestOAuth2AuthorizationServerMetadata;
import com.atlassian.oauth2.provider.rest.service.WellKnownRestService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@Path(value=".well-known")
@Produces(value={"application/json"})
@Singleton
@UnrestrictedAccess
public class WellKnownResource {
    private final OAuth2ProviderService oAuth2ProviderService;
    private final WellKnownRestService wellKnownRestService;

    @Inject
    public WellKnownResource(OAuth2ProviderService oAuth2ProviderService, WellKnownRestService wellKnownRestService) {
        this.oAuth2ProviderService = oAuth2ProviderService;
        this.wellKnownRestService = wellKnownRestService;
    }

    @XsrfProtectionExcluded
    @GET
    @Path(value="/oauth-authorization-server")
    @PublicApi
    public Response getOAuthAuthorizationServerMetadata(@QueryParam(value="applinks") String applinks) {
        OAuth2AuthorizationServerMetadata oAuth2AuthorizationServerMetadata = this.oAuth2ProviderService.getOAuth2AuthorizationServerMetadata();
        Set<String> scopesSupported = oAuth2AuthorizationServerMetadata.scopesSupported();
        Set<String> scopes = applinks != null && !applinks.isBlank() && applinks.equals("true") ? this.wellKnownRestService.filterApplinksAvailableScopes(scopesSupported) : scopesSupported;
        return Response.ok((Object)RestOAuth2AuthorizationServerMetadata.builder().issuer(oAuth2AuthorizationServerMetadata.issuer()).tokenEndpoint(oAuth2AuthorizationServerMetadata.tokenEndpoint()).revocationEndpoint(oAuth2AuthorizationServerMetadata.revocationEndpoint()).authorizationEndpoint(oAuth2AuthorizationServerMetadata.authorizationEndpoint()).scopesSupported(scopes).responseTypesSupported(oAuth2AuthorizationServerMetadata.responseTypesSupported()).responseModesSupported(oAuth2AuthorizationServerMetadata.responseModesSupported()).grantTypesSupported(oAuth2AuthorizationServerMetadata.grantTypesSupported()).tokenEndpointAuthMethodsSupported(oAuth2AuthorizationServerMetadata.tokenEndpointAuthMethodsSupported()).revocationEndpointAuthMethodsSupported(oAuth2AuthorizationServerMetadata.revocationEndpointAuthMethodsSupported()).build()).build();
    }
}

