/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service;

import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.rest.exception.ClientNotFoundException;
import com.atlassian.oauth2.provider.rest.model.ClientCredentialsDto;
import com.atlassian.sal.api.message.I18nResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotateClientService {
    private static final Logger logger = LoggerFactory.getLogger(RotateClientService.class);
    private final ClientService clientService;
    private final I18nResolver i18nResolver;

    public RotateClientService(ClientService clientService, I18nResolver i18nResolver) {
        this.clientService = clientService;
        this.i18nResolver = i18nResolver;
    }

    public ClientCredentialsDto rotate(String clientId) throws ClientNotFoundException {
        logger.debug("Rotating client id and secret associated with client id {}", (Object)clientId);
        return this.clientService.rotateClient(clientId).map(c -> new ClientCredentialsDto(c.getClientId(), c.getClientSecret())).orElseThrow(() -> new ClientNotFoundException(this.i18nResolver.getText("oauth2.rest.error.client.does.not.exist")));
    }
}

