/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service.grant;

import com.atlassian.oauth2.provider.api.token.access.AccessToken;
import com.atlassian.oauth2.provider.core.token.JwtService;
import com.atlassian.oauth2.provider.core.token.TokenService;
import com.atlassian.oauth2.provider.rest.model.RestToken;
import com.atlassian.oauth2.provider.rest.model.TokenRequestFormParams;
import com.atlassian.oauth2.provider.rest.service.TokenRestService;
import com.atlassian.oauth2.provider.rest.service.grant.GrantProcessor;
import com.atlassian.oauth2.provider.rest.service.grant.GrantProcessorUtils;
import com.atlassian.oauth2.provider.rest.validation.grant.GrantValidator;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import java.util.Set;

public class ClientCredentialsGrantProcessor
implements GrantProcessor {
    private final GrantValidator grantValidator;
    private final JwtService jwtService;
    private final TokenService tokenService;
    private final ScopeResolver scopeResolver;

    public ClientCredentialsGrantProcessor(GrantValidator grantValidator, JwtService jwtService, TokenService tokenService, ScopeResolver scopeResolver) {
        this.grantValidator = grantValidator;
        this.jwtService = jwtService;
        this.tokenService = tokenService;
        this.scopeResolver = scopeResolver;
    }

    @Override
    public RestToken execute(TokenRequestFormParams formParams) {
        this.grantValidator.validate(formParams);
        Set requestedScopes = this.scopeResolver.resolveAllGrantedScopesFromString(formParams.getScope());
        Set<Scope> scopes = GrantProcessorUtils.downgradeScope(requestedScopes, "client_credentials");
        AccessToken accessToken = this.tokenService.createClientCredentialsAccessToken(formParams.getClientId(), scopes);
        return TokenRestService.tokenEntityToRestTokenWithRefresh(this.jwtService.createToken(accessToken.getId()), null, ScopeResolver.serializeScopesToStr((Set)accessToken.getScopes()));
    }
}

