/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service.grant;

import com.atlassian.oauth2.scopes.api.Scope;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantProcessorUtils {
    private static final Logger logger = LoggerFactory.getLogger(GrantProcessorUtils.class);

    private GrantProcessorUtils() {
    }

    public static Set<Scope> downgradeScope(Set<Scope> scope, String supportedGrantType) {
        Stream allScopes = scope.stream().flatMap(s -> s.getScopeAndInheritedScopes().stream());
        return allScopes.filter(scopeItem -> {
            boolean supports = scopeItem.getSupportedGrantTypes().contains(supportedGrantType);
            if (!supports && logger.isDebugEnabled()) {
                logger.debug("Dropping unsupported scope '{}' from the scope '{}' for the grant type '{}'.", new Object[]{scopeItem, scope, supportedGrantType});
            }
            return supports;
        }).collect(Collectors.toSet());
    }
}

