/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.validation.grant;

import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.rest.exception.InvalidRequestException;
import com.atlassian.oauth2.provider.rest.model.TokenRequestFormParams;
import com.atlassian.oauth2.provider.rest.validation.grant.GrantValidator;
import com.atlassian.oauth2.scopes.api.InvalidScopeException;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsGrantValidator
extends GrantValidator {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialsGrantValidator.class);
    private final ScopeResolver scopeResolver;

    public static ClientCredentialsGrantValidator get(I18nResolver i18nResolver, ClientService clientService, ScopeResolver scopeResolver) {
        return new ClientCredentialsGrantValidator(i18nResolver, clientService, scopeResolver);
    }

    private ClientCredentialsGrantValidator(I18nResolver i18nResolver, ClientService clientService, ScopeResolver scopeResolver) {
        super(i18nResolver, clientService);
        this.scopeResolver = scopeResolver;
    }

    @Override
    public void validateGrantSpecificConstraints(TokenRequestFormParams formParams) {
        this.validateRequiredParams(formParams.requiredClientCredentialsTokenParams());
        this.validateScope(formParams);
    }

    public void validateScope(TokenRequestFormParams formParams) {
        String scope;
        Optional clientOptional = this.clientService.getByClientId(formParams.getClientId()).or(() -> this.clientService.getByRotatedClientId(formParams.getClientId()));
        if (clientOptional.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Client id '{}' not found.", (Object)formParams.getClientId());
            }
            throw new InvalidRequestException(this.i18nResolver.getText("oauth2.rest.error.client_credentials.invalid"));
        }
        Client client = (Client)clientOptional.get();
        if (!this.isScopeValid(client, scope = formParams.getScope())) {
            throw new InvalidRequestException(this.i18nResolver.getText("oauth2.rest.error.client_credentials.invalid"));
        }
    }

    private boolean isScopeValid(Client client, String scope) {
        try {
            return this.scopeResolver.hasScopePermission(this.scopeResolver.getScope(scope), client.getScope());
        }
        catch (InvalidScopeException e) {
            return false;
        }
    }
}

