/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.ServiceAccountSigner;
import com.google.auth.oauth2.AwsDates;
import com.google.auth.oauth2.AwsRequestSignature;
import com.google.auth.oauth2.AwsSecurityCredentials;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class AwsRequestSigner {
    private static final String HASHING_ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String AWS_REQUEST_TYPE = "aws4_request";
    private final AwsSecurityCredentials awsSecurityCredentials;
    private final Map<String, String> additionalHeaders;
    private final String httpMethod;
    private final String region;
    private final String requestPayload;
    private final URI uri;
    private final AwsDates dates;

    private AwsRequestSigner(AwsSecurityCredentials awsSecurityCredentials, String httpMethod, String url, String region, @Nullable String requestPayload, @Nullable Map<String, String> additionalHeaders, @Nullable AwsDates awsDates) {
        this.awsSecurityCredentials = (AwsSecurityCredentials)Preconditions.checkNotNull((Object)awsSecurityCredentials);
        this.httpMethod = (String)Preconditions.checkNotNull((Object)httpMethod);
        this.uri = URI.create(url).normalize();
        this.region = (String)Preconditions.checkNotNull((Object)region);
        this.requestPayload = requestPayload == null ? "" : requestPayload;
        this.additionalHeaders = additionalHeaders != null ? new HashMap<String, String>(additionalHeaders) : new HashMap();
        this.dates = awsDates == null ? AwsDates.generateXAmzDate() : awsDates;
    }

    AwsRequestSignature sign() {
        String serviceName = (String)Splitter.on((String)".").split((CharSequence)this.uri.getHost()).iterator().next();
        Map<String, String> canonicalHeaders = this.getCanonicalHeaders(this.dates.getOriginalDate());
        ArrayList<String> sortedHeaderNames = new ArrayList<String>();
        for (String headerName : canonicalHeaders.keySet()) {
            sortedHeaderNames.add(headerName.toLowerCase(Locale.US));
        }
        Collections.sort(sortedHeaderNames);
        String canonicalRequestHash = this.createCanonicalRequestHash(canonicalHeaders, sortedHeaderNames);
        String credentialScope = this.dates.getFormattedDate() + "/" + this.region + "/" + serviceName + "/" + AWS_REQUEST_TYPE;
        String stringToSign = this.createStringToSign(canonicalRequestHash, this.dates.getXAmzDate(), credentialScope);
        String signature = this.calculateAwsV4Signature(serviceName, this.awsSecurityCredentials.getSecretAccessKey(), this.dates.getFormattedDate(), this.region, stringToSign);
        String authorizationHeader = this.generateAuthorizationHeader(sortedHeaderNames, this.awsSecurityCredentials.getAccessKeyId(), credentialScope, signature);
        return new AwsRequestSignature.Builder().setSignature(signature).setCanonicalHeaders(canonicalHeaders).setHttpMethod(this.httpMethod).setSecurityCredentials(this.awsSecurityCredentials).setCredentialScope(credentialScope).setUrl(this.uri.toString()).setDate(this.dates.getOriginalDate()).setRegion(this.region).setAuthorizationHeader(authorizationHeader).build();
    }

    private String createCanonicalRequestHash(Map<String, String> headers, List<String> sortedHeaderNames) {
        StringBuilder canonicalRequest = new StringBuilder(this.httpMethod).append("\n");
        String urlPath = this.uri.getRawPath().isEmpty() ? "/" : this.uri.getRawPath();
        canonicalRequest.append(urlPath).append("\n");
        String actionQueryString = this.uri.getRawQuery() != null ? this.uri.getRawQuery() : "";
        canonicalRequest.append(actionQueryString).append("\n");
        StringBuilder canonicalHeaders = new StringBuilder();
        for (String headerName : sortedHeaderNames) {
            canonicalHeaders.append(headerName).append(":").append(headers.get(headerName)).append("\n");
        }
        canonicalRequest.append((CharSequence)canonicalHeaders).append("\n");
        canonicalRequest.append(Joiner.on((char)';').join(sortedHeaderNames)).append("\n");
        canonicalRequest.append(AwsRequestSigner.getHexEncodedSha256Hash(this.requestPayload.getBytes(StandardCharsets.UTF_8)));
        return AwsRequestSigner.getHexEncodedSha256Hash(canonicalRequest.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String createStringToSign(String canonicalRequestHash, String xAmzDate, String credentialScope) {
        return "AWS4-HMAC-SHA256\n" + xAmzDate + "\n" + credentialScope + "\n" + canonicalRequestHash;
    }

    private String calculateAwsV4Signature(String serviceName, String secret, String date, String region, String stringToSign) {
        byte[] kDate = AwsRequestSigner.sign(("AWS4" + secret).getBytes(StandardCharsets.UTF_8), date.getBytes(StandardCharsets.UTF_8));
        byte[] kRegion = AwsRequestSigner.sign(kDate, region.getBytes(StandardCharsets.UTF_8));
        byte[] kService = AwsRequestSigner.sign(kRegion, serviceName.getBytes(StandardCharsets.UTF_8));
        byte[] kSigning = AwsRequestSigner.sign(kService, AWS_REQUEST_TYPE.getBytes(StandardCharsets.UTF_8));
        return BaseEncoding.base16().lowerCase().encode(AwsRequestSigner.sign(kSigning, stringToSign.getBytes(StandardCharsets.UTF_8)));
    }

    private String generateAuthorizationHeader(List<String> sortedHeaderNames, String accessKeyId, String credentialScope, String signature) {
        return String.format("%s Credential=%s/%s, SignedHeaders=%s, Signature=%s", HASHING_ALGORITHM, accessKeyId, credentialScope, Joiner.on((char)';').join(sortedHeaderNames), signature);
    }

    private Map<String, String> getCanonicalHeaders(String defaultDate) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("host", this.uri.getHost());
        if (!this.additionalHeaders.containsKey("date")) {
            headers.put("x-amz-date", defaultDate);
        }
        if (this.awsSecurityCredentials.getToken() != null && !this.awsSecurityCredentials.getToken().isEmpty()) {
            headers.put("x-amz-security-token", this.awsSecurityCredentials.getToken());
        }
        for (String key : this.additionalHeaders.keySet()) {
            headers.put(key.toLowerCase(Locale.US), this.additionalHeaders.get(key));
        }
        return headers;
    }

    private static byte[] sign(byte[] key, byte[] value) {
        try {
            String algorithm = "HmacSHA256";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HmacSHA256 must be supported by the JVM.", e);
        }
        catch (InvalidKeyException e) {
            throw new ServiceAccountSigner.SigningException("Invalid key used when calculating the AWS V4 Signature", e);
        }
    }

    private static String getHexEncodedSha256Hash(byte[] bytes) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return BaseEncoding.base16().lowerCase().encode(digest.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute SHA-256 hash.", e);
        }
    }

    static Builder newBuilder(AwsSecurityCredentials awsSecurityCredentials, String httpMethod, String url, String region) {
        return new Builder(awsSecurityCredentials, httpMethod, url, region);
    }

    static class Builder {
        private final AwsSecurityCredentials awsSecurityCredentials;
        private final String httpMethod;
        private final String url;
        private final String region;
        @Nullable
        private String requestPayload;
        @Nullable
        private Map<String, String> additionalHeaders;
        @Nullable
        private AwsDates dates;

        private Builder(AwsSecurityCredentials awsSecurityCredentials, String httpMethod, String url, String region) {
            this.awsSecurityCredentials = awsSecurityCredentials;
            this.httpMethod = httpMethod;
            this.url = url;
            this.region = region;
        }

        Builder setRequestPayload(String requestPayload) {
            this.requestPayload = requestPayload;
            return this;
        }

        Builder setAdditionalHeaders(Map<String, String> additionalHeaders) {
            if (additionalHeaders.containsKey("date") && additionalHeaders.containsKey("x-amz-date")) {
                throw new IllegalArgumentException("One of {date, x-amz-date} can be specified, not both.");
            }
            try {
                if (additionalHeaders.containsKey("date")) {
                    this.dates = AwsDates.fromDateHeader(additionalHeaders.get("date"));
                }
                if (additionalHeaders.containsKey("x-amz-date")) {
                    this.dates = AwsDates.fromXAmzDate(additionalHeaders.get("x-amz-date"));
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("The provided date header value is invalid.", e);
            }
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        AwsRequestSigner build() {
            return new AwsRequestSigner(this.awsSecurityCredentials, this.httpMethod, this.url, this.region, this.requestPayload, this.additionalHeaders, this.dates);
        }
    }
}

