/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.paste.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseStatusException;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Path(value="/cloudappembed")
public class CloudAppEmbedResource {
    private static final String OEMBED_URL = "http://cl.ly/";
    private NonMarshallingRequestFactory requestFactory;

    @Inject
    public CloudAppEmbedResource(@ComponentImport NonMarshallingRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getOEmbed(@QueryParam(value="resource") String resource) {
        String url = OEMBED_URL + URLEncoder.encode(resource, StandardCharsets.UTF_8);
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, url);
        request.setHeader("Accept", "application/json");
        try {
            return Response.ok((Object)request.execute()).build();
        }
        catch (ResponseStatusException e) {
            return Response.status((int)e.getResponse().getStatusCode()).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

