/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.video;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.extra.widgetconnector.AbstractWidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.services.VelocityRenderService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={WidgetRenderer.class})
public class LoomRenderer
extends AbstractWidgetRenderer {
    public static final Pattern PATTERN = Pattern.compile("loom.com/share/([a-zA-Z0-9-]+)");
    public static final Pattern PATTERN_EMBED = Pattern.compile("loom.com/embed/([a-zA-Z0-9-]+)");
    private static final String VELOCITY_TEMPLATE = "com/atlassian/confluence/extra/widgetconnector/templates/iframe.vm";
    private static final int DEFAULT_WIDTH = 544;
    private static final int DEFAULT_HEIGHT = 306;
    private static final String SERVICE_NAME = "Loom";
    private final VelocityRenderService velocityRenderService;

    @Autowired
    public LoomRenderer(VelocityRenderService velocityRenderService) {
        this.velocityRenderService = velocityRenderService;
    }

    @VisibleForTesting
    public String getEmbedUrl(String url) {
        Matcher embedUrlMatcher = PATTERN_EMBED.matcher(url);
        if (embedUrlMatcher.find()) {
            return url;
        }
        Matcher patternMatcher = PATTERN.matcher(url);
        if (!patternMatcher.find()) {
            return "";
        }
        return url.replaceFirst("/share/", "/embed/");
    }

    @Override
    public String getEmbeddedHtml(String url, Map<String, String> params) {
        params.put("_template", VELOCITY_TEMPLATE);
        params.putIfAbsent("width", String.valueOf(544));
        params.putIfAbsent("height", String.valueOf(306));
        return this.velocityRenderService.render(this.getEmbedUrl(url), params);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }
}

