/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.widgetconnector.widgets;

import com.atlassian.confluence.extra.widgetconnector.AbstractWidgetRenderer;
import com.atlassian.confluence.extra.widgetconnector.WidgetRenderer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={WidgetRenderer.class})
public class SpotifyRenderer
extends AbstractWidgetRenderer {
    private static final Pattern SPOTIFY_URL_PATTERN = Pattern.compile("^https://open.spotify.com/(embed/)?(?<embed>(playlist|track|album|artist)/([A-Za-z0-9]){22})(\\?si=([A-Za-z0-9\\-_]){22})?$");
    private final SoyTemplateRenderer soyTemplateRenderer;
    private static final String SERVICE_NAME = "Spotify";

    @Autowired
    public SpotifyRenderer(@ComponentImport SoyTemplateRenderer soyTemplateRenderer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Override
    @Nullable
    public String getEmbeddedHtml(String url, Map<String, String> parameters) {
        Matcher matcher = SPOTIFY_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        String width = parameters.get("width");
        String height = parameters.get("height");
        ImmutableMap data = ImmutableMap.builder().put((Object)"width", (Object)Objects.toString(width, "300")).put((Object)"height", (Object)Objects.toString(height, "380")).put((Object)"url", (Object)String.format("https://open.spotify.com/embed/%s", matcher.group("embed"))).build();
        return this.soyTemplateRenderer.render("com.atlassian.confluence.extra.widgetconnector:soy-templates", "Confluence.Widget.Connector.spotify", (Map)data);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }
}

