/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentPermissionsQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.spaces.actions.ViewSpaceSummaryAction;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

@AnonymousSiteAccess
public class PagesCollectorAction
extends ViewSpaceSummaryAction {
    private SearchManager searchManager;
    private boolean showBlankExperience;
    private boolean hasCreatePermission;
    private String createPageLink;
    private final XsrfTokenGenerator simpleXsrfTokenGenerator;

    public PagesCollectorAction(@ComponentImport XsrfTokenGenerator simpleXsrfTokenGenerator) {
        this.simpleXsrfTokenGenerator = simpleXsrfTokenGenerator;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (this.space != null) {
            this.showBlankExperience = this.determineShowBlankExperience();
            this.createPageLink = "/pages/createpage.action?spaceKey=" + HtmlUtil.urlEncode((String)this.space.getKey(), (Charset)GeneralUtil.getDefaultCharset()) + this.getFromPageParam() + this.getAtlToken();
            this.hasCreatePermission = this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.get(), (Object)this.space, Page.class);
        }
        return super.execute();
    }

    public boolean getShowBlankExperience() {
        return this.showBlankExperience;
    }

    public boolean getHasCreatePermission() {
        return this.hasCreatePermission;
    }

    public String getCreatePageLink() {
        return this.createPageLink;
    }

    public String getRoot() {
        return this.space.getHomePage() != null ? "@home" : "@none";
    }

    private boolean determineShowBlankExperience() {
        if (this.space == null) {
            return false;
        }
        HashSet spaceKeys = Sets.newHashSet((Object[])new String[]{this.space.getKey()});
        InSpaceQuery inSpaceQuery = new InSpaceQuery((Set)spaceKeys);
        ContentTypeQuery contentTypeQuery = new ContentTypeQuery(ContentTypeEnum.PAGE);
        ContentPermissionsQuery contentPermissionsQuery = ContentPermissionsQuery.builder().build();
        SearchQuery searchQuery = BooleanQuery.andQuery((SearchQuery[])new SearchQuery[]{inSpaceQuery, contentTypeQuery, contentPermissionsQuery});
        ISearch search = ((ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)ContentSearch.builder().query(searchQuery)).startOffset(0)).limit(2)).build();
        try {
            SearchResults results = this.searchManager.search(search);
            return results.size() <= 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getFromPageParam() {
        Page homePage = this.space.getHomePage();
        return homePage == null ? "" : "&fromPageId=" + homePage.getIdAsString();
    }

    private String getAtlToken() {
        String token = this.simpleXsrfTokenGenerator.getToken(this.getActiveRequest(), true);
        return "&atl_token=" + token;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }
}

