/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.plugins.ia.SidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.SidebarLinkManager;
import com.atlassian.confluence.plugins.ia.impl.DefaultSidebarLink;
import com.atlassian.confluence.plugins.ia.impl.SidebarLinks;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@ExportAsService(value={SidebarLinkManager.class})
@Component(value="sidebarLinkManager")
public class CachingSidebarLinkManager
implements SidebarLinkManager {
    private static final String CACHE_NAME = CachingSidebarLinkManager.class.getName() + ".SidebarLinkCache";
    private final SidebarLinkManager delegate;
    private final Cache<String, SidebarLinks> cache;

    @Autowired
    public CachingSidebarLinkManager(@Qualifier(value="sidebarLinkManagerDelegate") SidebarLinkManager delegate, @ComponentImport CacheFactory cacheFactory) {
        this(delegate, CachingSidebarLinkManager.createCache(cacheFactory));
    }

    CachingSidebarLinkManager(SidebarLinkManager delegate, Cache<String, SidebarLinks> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    private static Cache<String, SidebarLinks> createCache(CacheFactory cacheFactory) {
        Cache cache = cacheFactory.getCache(CACHE_NAME);
        cache.removeAll();
        return cache;
    }

    private void invalidateCache(SidebarLink link) {
        this.cache.remove((Object)Objects.requireNonNull(link).getSpaceKey());
    }

    private void invalidateCache() {
        this.cache.removeAll();
    }

    private static SidebarLinks transformAoProxiesToDefaultSidebarLinks(com.atlassian.confluence.plugins.ia.SidebarLinks proxiedLinks) {
        return new SidebarLinks(proxiedLinks.getAllLinks().stream().map(DefaultSidebarLink::new).collect(Collectors.toList()));
    }

    public SidebarLink createLink(String spaceKey, SidebarLinkCategory category, SidebarLink.Type type, String webItemKey, int position, String customTitle, String hardcodedUrl, String customIconClass, long destResourceId) {
        SidebarLink newLink = this.delegate.createLink(spaceKey, category, type, webItemKey, position, customTitle, hardcodedUrl, customIconClass, destResourceId);
        this.invalidateCache(newLink);
        return newLink;
    }

    public void moveLink(SidebarLink link, int from, int to) {
        this.delegate.moveLink(link, from, to);
        this.invalidateCache(link);
    }

    public void deleteLink(SidebarLink link) {
        this.delegate.deleteLink(link);
        this.invalidateCache(link);
    }

    public void deleteLinks(long resourceId, SidebarLink.Type type) {
        this.delegate.deleteLinks(resourceId, type);
        this.invalidateCache();
    }

    public void deleteLinksForSpace(String spaceKey) {
        this.delegate.deleteLinksForSpace(spaceKey);
        this.invalidateCache();
    }

    public void hideLink(SidebarLink link) {
        this.delegate.hideLink(link);
        this.invalidateCache(link);
    }

    public void showLink(SidebarLink link) {
        this.delegate.showLink(link);
        this.invalidateCache(link);
    }

    public SidebarLink findById(int id) {
        return this.delegate.findById(id);
    }

    public SidebarLinks findBySpace(String spaceKey) {
        return (SidebarLinks)this.cache.get((Object)spaceKey, () -> CachingSidebarLinkManager.transformAoProxiesToDefaultSidebarLinks(this.delegate.findBySpace(spaceKey)));
    }
}

