/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.api.service.web.WebViewService;
import com.atlassian.confluence.content.render.xhtml.links.WebLink;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.ia.DisplayableSidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.SidebarLinkManager;
import com.atlassian.confluence.plugins.ia.impl.AbstractSidebarService;
import com.atlassian.confluence.plugins.ia.impl.AttachmentSidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.impl.ContentEntityObjectSidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.impl.DefaultSidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.impl.SidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.impl.SpaceSidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.rest.SidebarLinkBean;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@ExportAsService(value={SidebarLinkService.class})
@Component
public class DefaultSidebarLinkService
extends AbstractSidebarService
implements SidebarLinkService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSidebarLinkService.class);
    private final SidebarLinkManager sidebarLinkManager;
    private final ContentEntityManager contentEntityManager;
    private final AttachmentManager attachmentManager;
    private final Function<SidebarLink, SidebarLinkBean> linkToBeanTransformer;
    private final WebViewService webViewService;
    private final Map<SidebarLink.Type, SidebarLinkDelegate> sidebarLinkDelegates;
    private final Predicate<DisplayableSidebarLink> HIDDEN_LINKS_FILTER = new HiddenLinksFilter();
    private final Predicate<? super SidebarLink> permittedLinksFilter = new PermittedResourceLinksFilter();

    @Autowired
    DefaultSidebarLinkService(@Qualifier(value="sidebarLinkManager") SidebarLinkManager sidebarLinkManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport WebViewService webViewService, @Qualifier(value="defaultSidebarLinkDelegate") DefaultSidebarLinkDelegate defaultSidebarLinkDelegate, ContentEntityObjectSidebarLinkDelegate contentEntityObjectSidebarLinkDelegate, SpaceSidebarLinkDelegate spaceSidebarLinkDelegate, AttachmentSidebarLinkDelegate attachmentSidebarLinkDelegate) {
        super(permissionManager, spaceManager);
        this.sidebarLinkManager = sidebarLinkManager;
        this.contentEntityManager = contentEntityManager;
        this.attachmentManager = attachmentManager;
        this.webViewService = webViewService;
        this.sidebarLinkDelegates = DefaultSidebarLinkService.createSidebarLinkDelegates(defaultSidebarLinkDelegate, contentEntityObjectSidebarLinkDelegate, spaceSidebarLinkDelegate, attachmentSidebarLinkDelegate);
        this.linkToBeanTransformer = new LinkToBeanTransformer(this.sidebarLinkDelegates)::convert;
    }

    private static Map<SidebarLink.Type, SidebarLinkDelegate> createSidebarLinkDelegates(DefaultSidebarLinkDelegate defaultSidebarLinkDelegate, ContentEntityObjectSidebarLinkDelegate contentEntityObjectSidebarLinkDelegate, SpaceSidebarLinkDelegate spaceSidebarLinkDelegate, AttachmentSidebarLinkDelegate attachmentSidebarLinkDelegate) {
        HashMap<SidebarLink.Type, DefaultSidebarLinkDelegate> delegates = new HashMap<SidebarLink.Type, DefaultSidebarLinkDelegate>();
        delegates.put(null, defaultSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.WEB_ITEM, defaultSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.EXTERNAL_LINK, defaultSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.PINNED_PAGE, contentEntityObjectSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.PINNED_BLOG_POST, contentEntityObjectSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.PINNED_USER_INFO, contentEntityObjectSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.PINNED_SPACE, spaceSidebarLinkDelegate);
        delegates.put(SidebarLink.Type.PINNED_ATTACHMENT, attachmentSidebarLinkDelegate);
        return Collections.unmodifiableMap(delegates);
    }

    public List<DisplayableSidebarLink> getLinksForSpace(SidebarLinkCategory category, String spaceKey, boolean includeHiddenLinks) {
        this.checkViewPermissions(spaceKey);
        Stream<DisplayableSidebarLink> links = this.getLinksForSpace(category, spaceKey).stream();
        if (!includeHiddenLinks) {
            links = links.filter(this.HIDDEN_LINKS_FILTER);
        }
        return links.sorted().collect(Collectors.toList());
    }

    private Collection<DisplayableSidebarLink> getLinksForSpace(SidebarLinkCategory category, String spaceKey) {
        return switch (category) {
            default -> throw new MatchException(null, null);
            case SidebarLinkCategory.MAIN -> this.getLinksForSpace(spaceKey, SidebarLinkCategory.MAIN, "system.space.sidebar/main-links");
            case SidebarLinkCategory.ADVANCED -> this.getLinksForSpace(spaceKey, SidebarLinkCategory.ADVANCED, "system.space.sidebar/advanced-links");
            case SidebarLinkCategory.QUICK -> this.getPermittedQuickLinksForSpace(spaceKey);
        };
    }

    private Collection<DisplayableSidebarLink> getLinksForSpace(String spaceKey, SidebarLinkCategory category, String webSection) {
        Collection links = this.sidebarLinkManager.findBySpace(spaceKey).getLinks(category);
        Iterable webItems = this.webViewService.forSpace(spaceKey).getItemsForSection(webSection, null);
        ArrayList<SidebarLink> linksToDelete = new ArrayList<SidebarLink>();
        boolean needsRefresh = false;
        for (WebItemView item : webItems) {
            boolean matched = false;
            for (SidebarLink link2 : links) {
                if (!Objects.equals(item.getModuleKey(), link2.getWebItemKey())) continue;
                if (!matched) {
                    matched = true;
                    continue;
                }
                linksToDelete.add(this.sidebarLinkManager.findById(link2.getID()));
            }
            if (matched) continue;
            needsRefresh = true;
            this.sidebarLinkManager.createLink(spaceKey, category, SidebarLink.Type.WEB_ITEM, item.getModuleKey(), item.getWeight(), null, null, null, -2L);
        }
        for (SidebarLink link3 : linksToDelete) {
            needsRefresh = true;
            this.sidebarLinkManager.deleteLink(link3);
        }
        if (needsRefresh) {
            links = this.sidebarLinkManager.findBySpace(spaceKey).getLinks(category);
        }
        return links.stream().map(new WebItemAwareLinkToBeanTransformer(this.linkToBeanTransformer, webItems)::convert).filter(link -> StringUtils.isNotBlank((CharSequence)link.getTitle())).collect(Collectors.toList());
    }

    private Collection<DisplayableSidebarLink> getPermittedQuickLinksForSpace(String spaceKey) {
        Collection links = this.sidebarLinkManager.findBySpace(spaceKey).getLinks(SidebarLinkCategory.QUICK);
        return links.stream().filter(this.permittedLinksFilter).map(this.linkToBeanTransformer).collect(Collectors.toList());
    }

    public void move(String spaceKey, Integer id, Integer after) {
        this.move(id, after);
    }

    public void move(Integer id, Integer after) {
        int to;
        if (id == null) {
            log.warn("Couldn't move a sidebar link with null ID");
            return;
        }
        SidebarLink link = this.sidebarLinkManager.findById(id.intValue());
        if (link == null) {
            log.warn("Couldn't move a sidebar link with null ID");
            return;
        }
        String spaceKey = link.getSpaceKey();
        if (spaceKey == null) {
            log.warn("Couldn't move a sidebar link with null spacekey");
            return;
        }
        this.checkEditPermissions(spaceKey);
        SidebarLink afterLink = after == null ? null : this.sidebarLinkManager.findById(after.intValue());
        int from = link.getPosition();
        int n = to = afterLink == null ? 0 : afterLink.getPosition() + 1;
        if (to > from) {
            --to;
        }
        if (from != to) {
            this.sidebarLinkManager.moveLink(link, from, to);
        }
    }

    public void delete(Integer id) {
        if (id == null) {
            log.warn("Couldn't delete a sidebar link with null ID");
            return;
        }
        SidebarLink link = this.sidebarLinkManager.findById(id.intValue());
        if (link == null) {
            log.warn("Couldn't delete a sidebar link with null ID");
            return;
        }
        String spaceKey = link.getSpaceKey();
        if (spaceKey == null) {
            log.warn("Couldn't delete a sidebar link with null spacekey");
            return;
        }
        this.checkEditPermissions(spaceKey);
        this.sidebarLinkManager.deleteLink(link);
    }

    public SidebarLinkBean create(String spaceKey, Long pageId, String customTitle, String url, String iconClass) {
        this.checkEditPermissions(spaceKey);
        return this.forceCreate(spaceKey, pageId, customTitle, url, iconClass);
    }

    public SidebarLinkBean forceCreate(String spaceKey, Long pageId, String customTitle, String url, String iconClass) {
        ContentEntityObject page;
        String type = null;
        if (pageId != null && (page = this.contentEntityManager.getById(pageId.longValue())) != null) {
            type = page.getType();
        }
        return this.forceCreate(spaceKey, type, pageId, customTitle, url, iconClass);
    }

    public SidebarLinkBean create(String spaceKey, String resourceType, Long resourceId, String customTitle, String url, String iconClass) {
        this.checkEditPermissions(spaceKey);
        return this.forceCreate(spaceKey, resourceType, resourceId, customTitle, url, iconClass);
    }

    public SidebarLinkBean forceCreate(String spaceKey, String resourceType, Long resourceId, String customTitle, String url, String iconClass) {
        SidebarLink.Type type = SidebarLink.Type.fromResourceType((String)resourceType);
        SidebarLinkDelegate delegate = this.sidebarLinkDelegates.get(type);
        SidebarLink sidebarLink = delegate.createSidebarLink(spaceKey, resourceId, type, customTitle, url, iconClass);
        if (sidebarLink == null) {
            throw new IllegalStateException("Unable to create link");
        }
        return this.linkToBeanTransformer.apply(sidebarLink);
    }

    public void hide(Integer id) {
        if (id == null) {
            log.warn("Couldn't hide a sidebar link with null ID");
            return;
        }
        SidebarLink link = this.sidebarLinkManager.findById(id.intValue());
        if (link == null) {
            log.warn("Couldn't hide a sidebar link with null ID");
            return;
        }
        String spaceKey = link.getSpaceKey();
        if (spaceKey == null) {
            log.warn("Couldn't hide a sidebar link with null spacekey");
            return;
        }
        this.checkEditPermissions(spaceKey);
        if (link.getCategory() != SidebarLinkCategory.QUICK) {
            this.sidebarLinkManager.hideLink(link);
        }
    }

    public void show(Integer id) {
        if (id == null) {
            log.warn("Couldn't show a sidebar link with null ID");
            return;
        }
        SidebarLink link = this.sidebarLinkManager.findById(id.intValue());
        if (link == null) {
            log.warn("Couldn't show a sidebar link with null ID");
            return;
        }
        String spaceKey = link.getSpaceKey();
        if (spaceKey == null) {
            log.warn("Couldn't show a sidebar link with null spacekey");
            return;
        }
        this.checkEditPermissions(spaceKey);
        if (link.getCategory() != SidebarLinkCategory.QUICK) {
            this.sidebarLinkManager.showLink(link);
        }
    }

    public boolean hasQuickLink(String spaceKey, Long pageId) {
        this.checkViewPermissions(spaceKey);
        if (pageId == null) {
            return false;
        }
        Collection linksByDestPage = this.sidebarLinkManager.findBySpace(spaceKey).getLinksByDestPage(SidebarLinkCategory.QUICK, pageId.longValue());
        return !linksByDestPage.isEmpty();
    }

    public Collection<DisplayableSidebarLink> getQuickLinksForDestinationPage(String spaceKey, Long pageId) {
        this.checkEditPermissions(spaceKey);
        if (pageId == null) {
            return Collections.emptyList();
        }
        Collection links = this.sidebarLinkManager.findBySpace(spaceKey).getLinksByDestPage(SidebarLinkCategory.QUICK, pageId.longValue());
        return links.stream().map(this.linkToBeanTransformer).collect(Collectors.toList());
    }

    private static class HiddenLinksFilter
    implements Predicate<DisplayableSidebarLink> {
        private HiddenLinksFilter() {
        }

        @Override
        public boolean test(DisplayableSidebarLink sidebarLinkBean) {
            return !sidebarLinkBean.getCanHide() || !sidebarLinkBean.getHidden();
        }
    }

    private class PermittedResourceLinksFilter
    implements Predicate<SidebarLink> {
        private PermittedResourceLinksFilter() {
        }

        @Override
        public boolean test(SidebarLink link) {
            Space entity;
            long destPageId = link.getDestPageId();
            switch (link.getType()) {
                case EXTERNAL_LINK: {
                    return true;
                }
                case PINNED_SPACE: {
                    entity = DefaultSidebarLinkService.this.spaceManager.getSpace(destPageId);
                    break;
                }
                case PINNED_ATTACHMENT: {
                    entity = DefaultSidebarLinkService.this.attachmentManager.getAttachment(destPageId);
                    break;
                }
                default: {
                    entity = DefaultSidebarLinkService.this.contentEntityManager.getById(destPageId);
                }
            }
            return DefaultSidebarLinkService.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)entity);
        }
    }

    private record LinkToBeanTransformer(Map<SidebarLink.Type, SidebarLinkDelegate> sidebarLinkDelegates) {
        SidebarLinkBean convert(SidebarLink input) {
            return this.sidebarLinkDelegates.get(input.getType()).getSidebarLinkBean(input);
        }
    }

    private static class WebItemAwareLinkToBeanTransformer {
        private final Iterable<WebItemView> webItems;
        private final Function<SidebarLink, SidebarLinkBean> delegate;

        WebItemAwareLinkToBeanTransformer(Function<SidebarLink, SidebarLinkBean> linkToBeanTransformer, Iterable<WebItemView> webItems) {
            this.delegate = linkToBeanTransformer;
            this.webItems = webItems;
        }

        private WebItemView getWebItem(String key) {
            for (WebItemView webItem : this.webItems) {
                if (!webItem.getModuleKey().equals(key)) continue;
                return webItem;
            }
            return null;
        }

        SidebarLinkBean convert(SidebarLink input) {
            WebItemView item;
            SidebarLinkBean bean = this.delegate.apply(input);
            if (input.getType() == SidebarLink.Type.WEB_ITEM && (item = this.getWebItem(input.getWebItemKey())) != null) {
                bean.setTitle(item.getLabel());
                bean.setStyleClass(item.getStyleClass());
                bean.setUrl(WebLink.isValidURL((String)item.getLinkUrl()) ? item.getLinkUrl() : "#");
                bean.setUrlWithoutContextPath(WebLink.isValidURL((String)item.getUrlWithoutContextPath()) ? item.getUrlWithoutContextPath() : null);
                bean.setTooltip(item.getTooltip() == null ? item.getLabel() : item.getTooltip());
                bean.setCanHide(true);
            }
            return bean;
        }
    }
}

