/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.ia.impl.SidebarPageService;
import com.atlassian.confluence.plugins.ia.model.PageNodeBean;
import com.atlassian.confluence.plugins.ia.model.PagesBean;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.user.User;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DefaultSidebarPageService
implements SidebarPageService {
    private final ContextPathHolder contextPathHolder;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final ContentPermissionManager contentPermissionManager;
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final HttpContext httpContext;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private static final int MAX_INITIAL_PAGES = 5;
    private static final int DEFAULT_INITIAL_PAGES = 3;

    public DefaultSidebarPageService(@ComponentImport ContextPathHolder contextPathHolder, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport ContentPermissionManager contentPermissionManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport LocaleManager localeManager, @ComponentImport HttpContext httpContext, @ComponentImport XsrfTokenGenerator xsrfTokenGenerator) {
        this.contextPathHolder = contextPathHolder;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.httpContext = httpContext;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    @Override
    public PagesBean getPageContextualNav(long id) {
        Page page = this.pageManager.getPage(id);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
            return new PagesBean(null, null, Collections.emptyList(), Collections.emptyList(), this.getLinkToCreateChildPage(page));
        }
        if (page == null || !page.hasChildren()) {
            return new PagesBean(this.createParentPageBean(page), this.createCurrentPageBean(page), Collections.emptyList(), Collections.emptyList(), this.getLinkToCreateChildPage(page));
        }
        List children = this.contentPermissionManager.getPermittedChildren(page, AuthenticatedUserThreadLocal.get());
        if (children.size() > 5) {
            return new PagesBean(this.createParentPageBean(page), this.createCurrentPageBean(page), this.createChildPageBeans(children.subList(0, 3)), this.createChildPageBeans(children.subList(3, children.size())), this.getLinkToCreateChildPage(page));
        }
        return new PagesBean(this.createParentPageBean(page), this.createCurrentPageBean(page), this.createChildPageBeans(children), Collections.emptyList(), this.getLinkToCreateChildPage(page));
    }

    @Override
    public PagesBean getChildren(long id) {
        return this.getPageContextualNav(id);
    }

    private List<PageNodeBean> createChildPageBeans(List<Page> pages) {
        String contextPath = this.contextPathHolder.getContextPath();
        return pages.stream().map(page -> new PageNodeBean(page.getIdAsString(), page.getDisplayTitle(), contextPath + AddressablePage.of((AbstractPage)page).getUrlPath(), false)).collect(Collectors.toList());
    }

    private PageNodeBean createCurrentPageBean(Page page) {
        if (page == null) {
            return null;
        }
        return new PageNodeBean(page.getIdAsString(), page.getDisplayTitle(), this.contextPathHolder.getContextPath() + AddressablePage.of((AbstractPage)page).getUrlPath(), true);
    }

    private PageNodeBean createParentPageBean(Page page) {
        if (page == null) {
            return null;
        }
        Page parentPage = page.getParent();
        if (parentPage == null) {
            I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
            return new PageNodeBean(null, i18n.getText("sidebar.main.wiki"), this.contextPathHolder.getContextPath() + "/collector/pages.action?key=" + HtmlUtil.urlEncode((String)page.getSpaceKey(), (Charset)GeneralUtil.getDefaultCharset()), false);
        }
        return new PageNodeBean(parentPage.getIdAsString(), parentPage.getDisplayTitle(), this.contextPathHolder.getContextPath() + AddressablePage.of((AbstractPage)parentPage).getUrlPath(), false);
    }

    private String getLinkToCreateChildPage(Page page) {
        if (page == null) {
            return null;
        }
        return this.contextPathHolder.getContextPath() + "/pages/createpage.action?spaceKey=" + HtmlUtil.urlEncode((String)page.getSpaceKey(), (Charset)GeneralUtil.getDefaultCharset()) + "&fromPageId=" + page.getIdAsString() + "&atl_token=" + this.getXsrfToken();
    }

    private String getXsrfToken() {
        return this.xsrfTokenGenerator.getToken(this.httpContext.getActiveRequest(), true);
    }
}

