/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.plugins.ia.impl.SpaceBeanFactory;
import com.atlassian.confluence.plugins.ia.model.SpaceBean;
import com.atlassian.confluence.spaces.AddressableSpace;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.nio.charset.Charset;
import org.springframework.stereotype.Component;

@Component
public class DefaultSpaceBeanFactory
implements SpaceBeanFactory {
    private final SpaceLogoManager spaceLogoManager;
    private final ContextPathHolder contextPathHolder;

    public DefaultSpaceBeanFactory(@ComponentImport SpaceLogoManager spaceLogoManager, @ComponentImport ContextPathHolder contextPathHolder) {
        this.spaceLogoManager = spaceLogoManager;
        this.contextPathHolder = contextPathHolder;
    }

    @Override
    public SpaceBean createSpaceBean(Space space, ConfluenceUser currentUser) {
        String homePath = AddressableSpace.of((Space)space).getDeepLinkUri().toString();
        String logoUriReference = this.spaceLogoManager.getLogoUriReference(space, (User)currentUser);
        String contextPath = this.contextPathHolder.getContextPath();
        SpaceDescription spaceDescription = space.getDescription();
        return new SpaceBean(space.getKey(), space.getName(), spaceDescription != null ? spaceDescription.getBodyAsString() : "", contextPath + homePath, logoUriReference, contextPath + this.getBrowseUrlPath(space), space.isPersonal(), currentUser != null && space.isPersonal() && space.getKey().equals("~" + currentUser.getName()));
    }

    private String getBrowseUrlPath(Space space) {
        return "/collector/pages.action?key=" + HtmlUtil.urlEncode((String)space.getKey(), (Charset)GeneralUtil.getDefaultCharset());
    }
}

