/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.impl;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.plugins.ia.SidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkManager;
import com.atlassian.confluence.plugins.ia.impl.DefaultSidebarLinkDelegate;
import com.atlassian.confluence.plugins.ia.rest.SidebarLinkBean;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
class SpaceSidebarLinkDelegate
extends DefaultSidebarLinkDelegate {
    private final SpaceManager spaceManager;

    protected SpaceSidebarLinkDelegate(@Qualifier(value="sidebarLinkManager") SidebarLinkManager sidebarLinkManager, @ComponentImport SpaceManager spaceManager, @ComponentImport ContextPathHolder contextPathHolder) {
        super(sidebarLinkManager, contextPathHolder);
        this.spaceManager = spaceManager;
    }

    @Override
    public SidebarLink createSidebarLink(String spaceKey, Long spaceId, SidebarLink.Type type, String customTitle, String url, String iconClass) {
        SidebarLink sidebarLink = null;
        Space space = this.spaceManager.getSpace(spaceId.longValue());
        if (space != null) {
            sidebarLink = super.createSidebarLink(spaceKey, space.getId(), type, customTitle, null, iconClass);
        }
        return sidebarLink;
    }

    @Override
    public SidebarLinkBean getSidebarLinkBean(SidebarLink sidebarLink) {
        Space space = this.spaceManager.getSpace(sidebarLink.getDestPageId());
        return super.getSidebarLinkBean(this.getCustomizedSidebarLink(sidebarLink, (Addressable)space));
    }
}

