/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.ia.impl.BlogTreeService;
import com.atlassian.confluence.plugins.ia.model.DateNodeBean;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="pagetree/blog")
@AnonymousSiteAccess
@Produces(value={"application/json"})
public class BlogTreeResource {
    private final BlogTreeService blogTreeService;

    @Inject
    public BlogTreeResource(BlogTreeService blogTreeService) {
        this.blogTreeService = blogTreeService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getBlogTree(@QueryParam(value="pageId") long id) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        List<DateNodeBean> tree = this.blogTreeService.getBlogTree(user, id);
        return tree == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok(tree).build();
    }

    @GET
    @Path(value="subtree")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getBlogSubtree(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupType") int groupType, @QueryParam(value="groupValue") String groupValue) {
        List<Object> subtree = null;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (groupType == 1) {
            subtree = this.blogTreeService.getMonthsWithBlogPosts(user, spaceKey, groupValue);
        } else if (groupType == 2) {
            subtree = this.blogTreeService.getBlogsForMonth(user, spaceKey, groupValue);
        }
        return subtree == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok(subtree).build();
    }
}

