/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.recentlyviewed.api.RecentlyViewedManager;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.spaces.AddressableSpace;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Path(value="/spacesmenu")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RecentSpacesResource {
    private final RecentlyViewedManager recentlyViewedManager;
    private final SpaceLogoManager spaceLogoManager;
    private final TemplateRenderer templateRenderer;

    @Inject
    RecentSpacesResource(@ComponentImport SpaceLogoManager spaceLogoManager, @ComponentImport RecentlyViewedManager recentlyViewedManager, @ComponentImport TemplateRenderer templateRenderer) {
        this.spaceLogoManager = spaceLogoManager;
        this.recentlyViewedManager = recentlyViewedManager;
        this.templateRenderer = templateRenderer;
    }

    @GET
    @Path(value="/recent")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getRecentSpaces(@DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<Space> recentSpaces = this.getRecentlyViewedSpaces(user, limit);
        List<Map<String, String>> spaceMenuItems = this.getSpaceMenuItems(recentSpaces);
        return Response.ok(spaceMenuItems).build();
    }

    @GET
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ"})
    public Response getMenu(@DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        HashMap<String, List<Map<String, String>>> soyContext = new HashMap<String, List<Map<String, String>>>();
        if (user != null) {
            List<Space> recentSpaces = this.getRecentlyViewedSpaces(user, limit);
            List<Map<String, String>> spaceMenuItems = this.getSpaceMenuItems(recentSpaces);
            soyContext.put("recentSpaces", spaceMenuItems);
        }
        StringBuilder output = new StringBuilder();
        this.templateRenderer.renderTo((Appendable)output, "com.atlassian.confluence.plugins.confluence-space-ia:server-soy-resources", "Confluence.Templates.BrowseSpaces.dropdownMenu.soy", soyContext);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("template", output.toString());
        return Response.ok(result).build();
    }

    private List<Space> getRecentlyViewedSpaces(ConfluenceUser user, int limit) {
        return this.recentlyViewedManager.getRecentlyViewedSpaces(user.getKey().toString(), limit);
    }

    private List<Map<String, String>> getSpaceMenuItems(List<Space> recentSpaces) {
        return recentSpaces.stream().map(this::getSpaceItem).collect(Collectors.toList());
    }

    private Map<String, String> getSpaceItem(Space space) {
        return ImmutableMap.of((Object)"name", (Object)space.getName(), (Object)"key", (Object)space.getKey(), (Object)"href", (Object)AddressableSpace.of((Space)space).getDeepLinkUri().toString(), (Object)"logo", (Object)this.spaceLogoManager.getLogoUriReference(space, (User)AuthenticatedUserThreadLocal.get()));
    }
}

