/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.ia.DisplayableSidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Path(value="link")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SidebarLinkResource {
    private final SidebarLinkService sidebarLinkService;

    @Inject
    public SidebarLinkResource(SidebarLinkService sidebarLinkService) {
        this.sidebarLinkService = sidebarLinkService;
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="main")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getMainLinks(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="includeHidden") boolean includeHidden) {
        return Response.ok((Object)this.sidebarLinkService.getLinksForSpace(SidebarLinkCategory.MAIN, spaceKey, includeHidden)).build();
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="quick")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getQuickLinks(@QueryParam(value="spaceKey") String spaceKey) {
        return Response.ok((Object)this.sidebarLinkService.getLinksForSpace(SidebarLinkCategory.QUICK, spaceKey, false)).build();
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="advanced")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getAdvancedLinks(@QueryParam(value="spaceKey") String spaceKey) {
        return Response.ok((Object)this.sidebarLinkService.getLinksForSpace(SidebarLinkCategory.ADVANCED, spaceKey, false)).build();
    }

    @POST
    @Path(value="{id}/move")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response moveLink(@PathParam(value="id") String id, Map data) {
        String[] split;
        String after = (String)data.get("after");
        if (after != null && (split = after.split("link/")).length == 2) {
            after = split[1];
        }
        try {
            this.sidebarLinkService.move(Integer.valueOf(Integer.parseInt(id)), after == null ? null : Integer.valueOf(Integer.parseInt(after)));
            return Response.ok().build();
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Couldn't parse sidebar link ID").build();
        }
    }

    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createLink(Map<String, String> linkData) {
        try {
            DisplayableSidebarLink link;
            if (linkData.containsKey("resourceType")) {
                String resourceId;
                link = this.sidebarLinkService.create(linkData.get("spaceKey"), linkData.get("resourceType"), (resourceId = linkData.get("resourceId")) == null ? null : Long.valueOf(Long.parseLong(resourceId)), linkData.get("customTitle"), linkData.get("url"));
            } else {
                String pageId = linkData.get("pageId");
                if (StringUtils.isBlank((CharSequence)pageId)) {
                    pageId = linkData.get("resourceId");
                }
                link = this.sidebarLinkService.create(linkData.get("spaceKey"), pageId == null ? null : Long.valueOf(Long.parseLong(pageId)), linkData.get("customTitle"), linkData.get("url"));
            }
            return Response.ok((Object)link).build();
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Couldn't parse page ID").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response delete(@PathParam(value="id") String id) {
        try {
            this.sidebarLinkService.delete(Integer.valueOf(Integer.parseInt(id)));
            return Response.ok().build();
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Couldn't parse sidebar link ID").build();
        }
    }

    @POST
    @Path(value="{id}/hide")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response hide(@PathParam(value="id") String id) {
        try {
            this.sidebarLinkService.hide(Integer.valueOf(Integer.parseInt(id)));
            return Response.ok().build();
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Couldn't parse sidebar link ID").build();
        }
    }

    @POST
    @Path(value="{id}/show")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response show(@PathParam(value="id") String id) {
        try {
            this.sidebarLinkService.show(Integer.valueOf(Integer.parseInt(id)));
            return Response.ok().build();
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Couldn't parse sidebar link ID").build();
        }
    }
}

