/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.ia.impl.SidebarPageService;
import com.atlassian.confluence.plugins.ia.impl.SpaceBeanFactory;
import com.atlassian.confluence.plugins.ia.impl.SpaceLogoService;
import com.atlassian.confluence.plugins.ia.rest.SpaceDetailsBean;
import com.atlassian.confluence.plugins.ia.rest.TempLogoBean;
import com.atlassian.confluence.plugins.ia.service.SidebarService;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.TemporaryUploadedPicture;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.core.exception.FailedPredicateException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Path(value="space")
@AnonymousSiteAccess
@Produces(value={"application/json"})
public class SpaceSidebarResource {
    private static final String TEMP_SPACE_LOGO = "temp_space_logo";
    private final SpaceManager spaceManager;
    private final SpaceBeanFactory spaceBeanFactory;
    private final SpaceLogoService spaceLogoService;
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final SidebarService sidebarService;
    private final SidebarPageService sidebarPageService;
    private final SpacePermissionManager spacePermissionManager;
    private final HttpContext httpContext;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public SpaceSidebarResource(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport SpaceManager spaceManager, SpaceBeanFactory spaceBeanFactory, SpaceLogoService spaceLogoService, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, SidebarService sidebarService, SidebarPageService sidebarPageService, SpacePermissionManager spacePermissionManager, HttpContext httpContext) {
        this.spaceManager = spaceManager;
        this.spaceBeanFactory = spaceBeanFactory;
        this.spaceLogoService = spaceLogoService;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.sidebarService = sidebarService;
        this.sidebarPageService = sidebarPageService;
        this.spacePermissionManager = spacePermissionManager;
        this.httpContext = httpContext;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Path(value="childPagesContextualNav")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getContextualNav(@QueryParam(value="pageId") long pageId) {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                return Response.ok((Object)this.sidebarPageService.getPageContextualNav(pageId)).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getSpaceData(@QueryParam(value="spaceKey") String spaceKey) {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                Space space = this.spaceManager.getSpace(spaceKey);
                if (space == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                ConfluenceUser user = AuthenticatedUserThreadLocal.get();
                if (!this.spacePermissionManager.hasPermission("VIEWSPACE", space, user)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                return Response.ok((Object)this.spaceBeanFactory.createSpaceBean(space, this.getCurrentUser())).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @POST
    @Path(value="option")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setOption(Map<String, String> data) {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                this.sidebarService.setOption((String)data.get("spaceKey"), (String)data.get("option"), (String)data.get("value"));
                return Response.ok().build();
            }
            catch (NotPermittedException e) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @GET
    @Path(value="defaultLogo")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDefaultLogo() {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                return Response.ok((Object)new SpaceDetailsBean(null, this.spaceManager.getLogoForGlobalcontext())).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Path(value="uploadLogo")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response postNewLogo(@MultipartFormParam(value="upload-logo-input") FilePart filePart) {
        return (Response)this.transactionTemplate.execute(() -> {
            Gson gson = new Gson();
            String outputFormat = "<html><body><textarea id=\"json-response\">%s</textarea></body></html>";
            try {
                TemporaryUploadedPicture pic = this.spaceLogoService.createTempLogoFile(filePart);
                if (pic != null) {
                    this.httpContext.getActiveSession(true).setAttribute(TEMP_SPACE_LOGO, (Object)pic);
                    return Response.ok((Object)String.format(outputFormat, gson.toJson((Object)new TempLogoBean(pic)))).build();
                }
                I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)this.getCurrentUser()));
                return Response.ok((Object)String.format(outputFormat, gson.toJson((Object)new TempLogoBean(i18n.getText("upload.not.a.picture"))))).build();
            }
            catch (FailedPredicateException e) {
                I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)this.getCurrentUser()));
                return Response.ok((Object)String.format(outputFormat, gson.toJson((Object)new TempLogoBean(i18n.getText("upload.too.large"))))).build();
            }
            catch (IOException e) {
                return Response.serverError().build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @POST
    @Path(value="setLogo")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setLogo(SpaceSettingsInformation spaceSettings) {
        return (Response)this.transactionTemplate.execute(() -> {
            try {
                Space space = this.spaceManager.getSpace(spaceSettings.getSpaceKey());
                this.spaceLogoService.changeSpaceName(space, spaceSettings.getSpaceName());
                if (StringUtils.isNotEmpty((CharSequence)spaceSettings.getLogoDataURI())) {
                    this.spaceLogoService.saveLogo(space, spaceSettings.getLogoDataURI());
                }
                return Response.ok((Object)new SpaceDetailsBean(space.getName(), this.spaceManager.getLogoForSpace(spaceSettings.getSpaceKey()))).build();
            }
            catch (NotPermittedException e) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected ConfluenceUser getCurrentUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    @XmlRootElement
    private static class SpaceSettingsInformation {
        @XmlElement
        private String spaceKey;
        @XmlElement
        private String spaceName;
        @XmlElement
        private String logoDataURI;

        private SpaceSettingsInformation() {
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        public String getSpaceName() {
            return this.spaceName;
        }

        public void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        public String getLogoDataURI() {
            return this.logoDataURI;
        }

        public void setLogoDataURI(String logoDataURI) {
            this.logoDataURI = logoDataURI;
        }
    }
}

