/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.rpc;

import com.atlassian.confluence.plugins.ia.DisplayableSidebarLink;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.rpc.SidebarXmlRpc;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.plugins.ia.service.SidebarService;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.sal.api.transaction.TransactionTemplate;

public class SidebarXmlRpcImpl
implements SidebarXmlRpc {
    private final SidebarLinkService sidebarLinkService;
    private final TransactionTemplate transactionTemplate;
    private final SidebarService sidebarService;

    public SidebarXmlRpcImpl(SidebarLinkService sidebarLinkService, TransactionTemplate transactionTemplate, SidebarService sidebarService) {
        this.sidebarLinkService = sidebarLinkService;
        this.transactionTemplate = transactionTemplate;
        this.sidebarService = sidebarService;
    }

    @Override
    public boolean addSidebarQuickLink(String token, String spaceKey, String pageId, String title, String customClass) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            if (this.sidebarLinkService.hasQuickLink(spaceKey, Long.valueOf(Long.parseLong(pageId)))) {
                return false;
            }
            this.sidebarLinkService.create(spaceKey, Long.valueOf(Long.parseLong(pageId)), title, null, customClass);
            return true;
        });
    }

    @Override
    public boolean addSidebarQuickLink(String token, String spaceKey, String resourceType, String resourceId, String title, String customClass) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            if (this.sidebarLinkService.hasQuickLink(spaceKey, Long.valueOf(Long.parseLong(resourceId)))) {
                return false;
            }
            this.sidebarLinkService.create(spaceKey, resourceType, Long.valueOf(Long.parseLong(resourceId)), title, null, customClass);
            return true;
        });
    }

    @Override
    public boolean removeSidebarQuickLink(String token, String spaceKey, String pageId) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            for (DisplayableSidebarLink link : this.sidebarLinkService.getQuickLinksForDestinationPage(spaceKey, Long.valueOf(Long.parseLong(pageId)))) {
                this.sidebarLinkService.delete(Integer.valueOf(link.getId()));
            }
            return true;
        });
    }

    @Override
    public boolean removeSidebarQuickLinks(String token, String spaceKey) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            for (DisplayableSidebarLink link : this.sidebarLinkService.getLinksForSpace(SidebarLinkCategory.QUICK, spaceKey, false)) {
                this.sidebarLinkService.delete(Integer.valueOf(link.getId()));
            }
            return true;
        });
    }

    @Override
    public String getOption(String token, String spaceKey, String option) throws RemoteException {
        String navType = this.sidebarService.getOption(spaceKey, option);
        return navType != null ? navType : "page-tree";
    }

    @Override
    public boolean setOption(String token, String spaceKey, String option, String value) throws RemoteException {
        try {
            this.sidebarService.setOption(spaceKey, option, value);
            return true;
        }
        catch (NotPermittedException e) {
            throw new RuntimeException(e);
        }
    }
}

