/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.ia.ui;

import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SoySidebarHeaderContextProvider
implements ContextProvider {
    private static final String SIDEBAR_WIDTH_KEY = "confluence-sidebar.width";
    private static final String DEFAULT_SIDEBAR_WIDTH = "285";
    private final HttpContext httpContext;

    public SoySidebarHeaderContextProvider(@ComponentImport HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        String sidebarWidth = DEFAULT_SIDEBAR_WIDTH;
        if (request != null && request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(SIDEBAR_WIDTH_KEY) || !StringUtils.isNumeric((CharSequence)cookie.getValue())) continue;
                sidebarWidth = cookie.getValue();
                break;
            }
        }
        context.put("sidebarWidth", sidebarWidth);
        return context;
    }
}

