/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi;

import com.atlassian.confluence.efi.OnboardingManager;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LifecycleAware.class})
public class OnboardingManagerImpl
implements OnboardingManager,
LifecycleAware {
    private final GlobalStorageService globalStorageService;
    private String pluginInstalledDateInMillis;

    @Autowired
    public OnboardingManagerImpl(GlobalStorageService globalStorageService) {
        this.globalStorageService = globalStorageService;
    }

    public void onStart() {
        if (this.getPluginInstalledDateInMillis() == Long.MIN_VALUE) {
            this.pluginInstalledDateInMillis = String.valueOf(DateTime.now().getMillis());
            this.globalStorageService.set("plugin-installed-date-in-millis", this.pluginInstalledDateInMillis);
        }
    }

    public void onStop() {
    }

    @Override
    public boolean isFirstSpaceCreated() {
        return StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.globalStorageService.get("is-first-space-created"));
    }

    @Override
    public long getPluginInstalledDateInMillis() {
        this.pluginInstalledDateInMillis = StringUtils.isEmpty((CharSequence)this.pluginInstalledDateInMillis) ? this.globalStorageService.get("plugin-installed-date-in-millis") : this.pluginInstalledDateInMillis;
        return StringUtils.isEmpty((CharSequence)this.pluginInstalledDateInMillis) ? Long.MIN_VALUE : Long.parseLong(this.pluginInstalledDateInMillis);
    }
}

