/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.emails.notifications;

import com.atlassian.confluence.efi.emails.notifications.OnboardingPayload;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.notifications.ConfluenceUserRole;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RecipientsProviderTemplate;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OnboardingRecipientsProvider
extends RecipientsProviderTemplate<OnboardingPayload> {
    private static final ConfluenceUserRole ONBOARDING_ROLE = new ConfluenceUserRole("ONBOARDING");
    private final UserAccessor userAccessor;

    public OnboardingRecipientsProvider(@ComponentImport UserAccessor userAccessor) {
        super(OnboardingPayload.class);
        this.userAccessor = userAccessor;
    }

    protected Iterable<RoleRecipient> computeUserBasedRecipients(Notification<OnboardingPayload> notification) {
        Optional originator = ((OnboardingPayload)notification.getPayload()).getOriginatorUserKey();
        UserKey userKey = (UserKey)originator.get();
        ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
        ArrayList roleRecipients = Lists.newArrayList();
        roleRecipients.add(new UserKeyRoleRecipient((UserRole)ONBOARDING_ROLE, user.getKey(), originator.isPresent() && ((UserKey)originator.get()).equals((Object)user.getKey())));
        return roleRecipients;
    }

    public Iterable<UserRole> getUserRoles() {
        return Iterables.transform(List.of(Notification.WatchType.values()), watchType -> new ConfluenceUserRole(watchType.name()));
    }
}

