/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.emails.notifications;

import com.atlassian.confluence.efi.emails.notifications.OnboardingPayload;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.RenderContextProviderTemplate;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OnboardingRenderContextFactory
extends RenderContextProviderTemplate<OnboardingPayload> {
    private static final String EMAIL_TEMPLATE_RESOURCE_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-onboarding:onboarding-email-soy-templates";
    private final NotificationUserService notificationUserService;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final GlobalSettingsManager settingsManager;

    public OnboardingRenderContextFactory(@ComponentImport NotificationUserService notificationUserService, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport GlobalSettingsManager settingsManager) {
        super(OnboardingPayload.class);
        this.notificationUserService = notificationUserService;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.settingsManager = settingsManager;
    }

    public Optional<Map<String, Object>> checkedCreate(Notification<OnboardingPayload> notification, ServerConfiguration serverConfiguration, NotificationAddress notificationAddress) {
        return Optional.empty();
    }

    public Optional<Map<String, Object>> checkedCreate(Notification<OnboardingPayload> notification, ServerConfiguration serverConfiguration, RoleRecipient recipient) {
        User recipientUser = this.notificationUserService.findUserForKey(recipient.getUserKey());
        User actionUser = this.notificationUserService.findUserByKey(recipientUser, ((OnboardingPayload)notification.getPayload()).getOriginatorUserKey());
        NotificationContext notificationContext = new NotificationContext();
        notificationContext.setActor(actionUser);
        notificationContext.setRecipient(recipientUser);
        OnboardingRenderContextFactory.computeWatchTypeFrom(recipient.getRole()).ifPresent(arg_0 -> ((NotificationContext)notificationContext).setWatchType(arg_0));
        HashMap<String, String> enhancedContext = new HashMap<String, String>();
        enhancedContext.put("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        enhancedContext.put("createSpaceImgUrl", this.webResourceUrlProvider.getStaticPluginResourceUrl(EMAIL_TEMPLATE_RESOURCE_MODULE_KEY, "notifications/images/create-space.png", UrlMode.ABSOLUTE));
        enhancedContext.put("teamImgUrl", this.webResourceUrlProvider.getStaticPluginResourceUrl(EMAIL_TEMPLATE_RESOURCE_MODULE_KEY, "notifications/images/team.png", UrlMode.ABSOLUTE));
        enhancedContext.put("confluenceImgUrl", this.webResourceUrlProvider.getStaticPluginResourceUrl(EMAIL_TEMPLATE_RESOURCE_MODULE_KEY, "notifications/images/confluence.png", UrlMode.ABSOLUTE));
        enhancedContext.put("atlassianImgUrl", this.webResourceUrlProvider.getStaticPluginResourceUrl(EMAIL_TEMPLATE_RESOURCE_MODULE_KEY, "notifications/images/atlassian.png", UrlMode.ABSOLUTE));
        enhancedContext.put("versionNumber", BuildInformation.INSTANCE.getVersionNumber());
        notificationContext.putAll(enhancedContext);
        return Optional.ofNullable(notificationContext.getMap());
    }

    private static Optional<Notification.WatchType> computeWatchTypeFrom(UserRole role) {
        try {
            return Optional.of(Notification.WatchType.valueOf((String)role.getID()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }
}

