/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.emails.scheduling;

import com.atlassian.confluence.efi.emails.events.OnboardingEvent;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.user.Group;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;

public abstract class AbstractOnboardingJob
implements JobRunner {
    private static final String JOB_STATUS_FIRST_EXECUTE = "JOB_FIRST_EXECUTE";
    private static final String JOB_STATUS_EXECUTED = "JOB_EXECUTED";
    protected final UserAccessor userAccessor;
    protected final EventPublisher eventPublisher;
    protected final CrowdService crowdService;
    protected final GlobalStorageService globalStorageService;

    public AbstractOnboardingJob(UserAccessor userAccessor, EventPublisher eventPublisher, CrowdService crowdService, GlobalStorageService globalStorageService) {
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.crowdService = crowdService;
        this.globalStorageService = globalStorageService;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        String jobName = request.getJobId().toString();
        String jobStatus = this.globalStorageService.get(jobName);
        if (JOB_STATUS_EXECUTED.equals(jobStatus)) {
            return JobRunnerResponse.aborted((String)"Job need not be executed again");
        }
        if (jobStatus == null) {
            this.globalStorageService.set(jobName, JOB_STATUS_FIRST_EXECUTE);
            return JobRunnerResponse.aborted((String)"Job need not be executed immediately on startup");
        }
        this.globalStorageService.set(jobName, JOB_STATUS_EXECUTED);
        this.doExecute();
        return JobRunnerResponse.success();
    }

    protected void triggerEvent() {
        this.getFirstAdmin().ifPresent(admin -> this.eventPublisher.publish((Object)this.createEventForUser(admin.getKey())));
    }

    protected abstract void doExecute();

    protected abstract OnboardingEvent createEventForUser(UserKey var1);

    private Optional<ConfluenceUser> getFirstAdmin() {
        ConfluenceUser firstAdminConfUser = null;
        Group adminGroup = this.userAccessor.getGroup("confluence-administrators");
        ImmutableList confluenceUsers = ImmutableList.copyOf((Iterable)this.userAccessor.getMembers(adminGroup));
        if (!Iterables.isEmpty((Iterable)confluenceUsers)) {
            Iterable users = Iterables.transform((Iterable)confluenceUsers, input -> this.crowdService.getUser(input.getName()));
            Iterable sortedUsers = Iterables.mergeSorted(List.of(users), (u1, u2) -> {
                if (u1 instanceof TimestampedUser) {
                    TimestampedUser user1 = (TimestampedUser)u1;
                    if (u2 instanceof TimestampedUser) {
                        TimestampedUser user2 = (TimestampedUser)u2;
                        return user1.getCreatedDate().compareTo(user2.getCreatedDate());
                    }
                }
                return 0;
            });
            User firstAdmin = (User)sortedUsers.iterator().next();
            firstAdminConfUser = this.userAccessor.getUserByName(firstAdmin.getName());
        }
        return Optional.ofNullable(firstAdminConfUser);
    }
}

