/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.efi.rest.beans.StorageBean;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.confluence.efi.store.UserStorageService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="store")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConfluenceStorageResource {
    private final UserStorageService userStorageService;
    private final GlobalStorageService globalStorageService;
    private final PermissionManager permissionManager;

    @Inject
    public ConfluenceStorageResource(UserStorageService userStorageService, GlobalStorageService globalStorageService, @ComponentImport PermissionManager permissionManager) {
        this.userStorageService = userStorageService;
        this.permissionManager = permissionManager;
        this.globalStorageService = globalStorageService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getStorage(@QueryParam(value="key") String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || StringUtils.isEmpty((CharSequence)key)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String value = this.userStorageService.get(key, user);
        return Response.ok((Object)new StorageBean(key, value)).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setStorage(StorageBean bean) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || bean == null || StringUtils.isEmpty((CharSequence)bean.getKey()) || StringUtils.isEmpty((CharSequence)bean.getValue())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.userStorageService.set(bean.getKey(), bean.getValue(), user);
        return Response.ok((Object)bean).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteStorage(StorageBean bean) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || bean == null || StringUtils.isEmpty((CharSequence)bean.getKey())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.REMOVE, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.userStorageService.remove(bean.getKey(), user);
        return Response.noContent().build();
    }

    @GET
    @Path(value="global")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getGlobalStorage(@QueryParam(value="key") String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || StringUtils.isEmpty((CharSequence)key)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)new StorageBean(key, this.globalStorageService.get(key))).build();
    }

    @PUT
    @Path(value="global")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setGlobalStorage(StorageBean bean) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || bean == null || StringUtils.isEmpty((CharSequence)bean.getKey()) || StringUtils.isEmpty((CharSequence)bean.getValue())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.globalStorageService.set(bean.getKey(), bean.getValue());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="global")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteGlobalStorage(StorageBean bean) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || bean == null || StringUtils.isEmpty((CharSequence)bean.getKey())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.permissionManager.hasPermission(user, Permission.REMOVE, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.globalStorageService.remove(bean.getKey());
        return Response.noContent().build();
    }
}

