/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="draft")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DraftResource {
    private static final Logger logger = LoggerFactory.getLogger(DraftResource.class);
    private static final Map<String, String> TEMPLATES_SOY_MAP = Map.of("meeting-notes-item", "Confluence.Templates.OB.Blueprint.meetingNotes", "requirements-item", "Confluence.Templates.OB.Blueprint.requirements", "decisions-item", "Confluence.Templates.OB.Blueprint.decisions");
    private static final Map<String, String> MIMETYPE_MAP = Map.of(".png", "image/png", ".jpg", "image/jpeg");
    private static final String[] IMAGES_OF_REQUIREMENTS = new String[]{"mobile_activity_screen.png", "mobile_login_screen.png"};
    private static final String[] IMAGES_OF_MEETING_NOTES = new String[]{"design_feedback.jpg"};
    private static final String[] IMAGES_OF_DECISIONS = new String[]{"cake.jpg", "pie.png"};
    private static final String REQUIREMENTS_DIR = "requirements/";
    private static final String MEETING_NOTES_DIR = "meeting-notes/";
    private static final String DECISIONS_DIR = "decisions/";
    private static final String BLUEPRINT_TEMPLATES_DIR = "/blueprint-templates/";
    private static final String BLUEPRINT_IMAGES_DIR = "/blueprint-templates/images/";
    private static final String BLUEPRINT_TEMPLATES_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-onboarding:onboarding-blueprint-templates-resources";
    private final FormatConverter formatConverter;
    private final FileUploadManager fileUploadManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final DraftsTransitionHelper draftsTransitionHelper;

    @Inject
    public DraftResource(@ComponentImport FormatConverter formatConverter, @ComponentImport FileUploadManager fileUploadManager, @ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport DraftsTransitionHelper draftsTransitionHelper) {
        this.formatConverter = formatConverter;
        this.fileUploadManager = fileUploadManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    @Path(value="generate")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response generateDraft(@QueryParam(value="spaceKey") String spaceKey) throws IOException {
        if (StringUtils.isEmpty((CharSequence)spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of("error", "spaceKey must be not empty")).build();
        }
        ContentEntityObject draft = this.draftsTransitionHelper.createDraft("page", spaceKey);
        this.attachImagesToDraft(draft);
        logger.debug("Pre-generated draft with ID {}", (Object)draft.getId());
        return Response.ok((Object)draft.getId()).build();
    }

    @Path(value="{draftId}/body/templates")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDraftTemplates(@PathParam(value="draftId") long draftId) throws SoyException {
        if (draftId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of("error", "DraftId '" + draftId + "' must be a valid number")).build();
        }
        ContentEntityObject draft = this.draftsTransitionHelper.getDraft(draftId);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userkey", AuthenticatedUserThreadLocal.get().getKey().getStringValue());
        HashMap<String, String> maps = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : TEMPLATES_SOY_MAP.entrySet()) {
            String renderedStorageFormat = this.soyTemplateRenderer.render(BLUEPRINT_TEMPLATES_MODULE_KEY, entry.getValue(), data);
            String editorFormat = this.formatConverter.convertToEditorFormat(renderedStorageFormat, (RenderContext)new PageContext(draft));
            maps.put(entry.getKey(), editorFormat);
        }
        return Response.ok(maps).build();
    }

    private void attachImagesToDraft(ContentEntityObject draft) throws IOException {
        this.attachImages(draft, REQUIREMENTS_DIR, IMAGES_OF_REQUIREMENTS);
        this.attachImages(draft, MEETING_NOTES_DIR, IMAGES_OF_MEETING_NOTES);
        this.attachImages(draft, DECISIONS_DIR, IMAGES_OF_DECISIONS);
    }

    private void attachImages(ContentEntityObject draft, String subFolder, String ... imagesOfRequirements) throws IOException {
        for (String filename : imagesOfRequirements) {
            String extension = filename.substring(filename.lastIndexOf("."));
            URL url = this.getClass().getResource(BLUEPRINT_IMAGES_DIR + subFolder + filename);
            try (InputStream is = url.openStream();){
                this.fileUploadManager.storeResource((AttachmentResource)new InputStreamAttachmentResource(is, filename, MIMETYPE_MAP.get(extension), (long)is.available(), null, false), draft);
            }
        }
    }
}

