/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.store;

import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalStorageServiceImpl
implements GlobalStorageService {
    public static final String NPS_KEY = "com.atlassian.nps.plugin.status.nps_enabled";
    public static final String GLOBAL_STORAGE_NAMESPACE = GlobalStorageServiceImpl.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalStorageServiceImpl.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginSettings pluginSettings;
    private final ConfluenceJsonObjectMapper jsonObjectMapper = new ConfluenceJsonObjectMapper();

    @Autowired
    public GlobalStorageServiceImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(GLOBAL_STORAGE_NAMESPACE);
    }

    @Override
    public String get(String key) {
        return (String)this.pluginSettings.get("efi.store.onboarding." + key);
    }

    @Override
    public boolean set(String key, String value) {
        this.pluginSettings.put("efi.store.onboarding." + key, (Object)value);
        return true;
    }

    @Override
    public void remove(String key) {
        this.pluginSettings.remove("efi.store.onboarding." + key);
    }

    @Override
    public String getNpsEnabledSetting() {
        try {
            return (String)this.pluginSettingsFactory.createGlobalSettings().get(NPS_KEY);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Couldn't check the NPS status. This can safely be ignored during plugin shutdown. Detail: {}", (Object)e.getMessage());
            return null;
        }
    }
}

